<?php

class EventController extends Controller
{

  public function show($slug)
  {
    $eventModel = $this->model('Event');
    $event = $eventModel->findBySlug($slug); // Need to implement this

    if (!$event) {
      http_response_code(404);
      die("Evento não encontrado.");
    }

    $ticketModel = $this->model('TicketType');
    $tickets = $ticketModel->getByEventId($event['id']);

    $speakerModel = $this->model('EventSpeaker');
    $speakers = $speakerModel->getByEventId($event['id']);

    $this->view('event/details', ['event' => $event, 'tickets' => $tickets, 'speakers' => $speakers]);
  }
}
