<?php

class HomeController extends Controller
{
  public function index()
  {
    $eventModel = $this->model('Event');

    // Check if there is a highlighted event
    $featuredEvent = $eventModel->getHighlighted();

    if ($featuredEvent) {
      // Render detailed view for the featured event (Landing Page Mode)
      $ticketModel = $this->model('TicketType');
      $tickets = $ticketModel->getByEventId($featuredEvent['id']);

      $speakerModel = $this->model('EventSpeaker');
      $speakers = $speakerModel->getByEventId($featuredEvent['id']);

      // Check if there are other events to show the button
      $otherEvents = $eventModel->getAllOthers($featuredEvent['id']);
      $hasOtherEvents = !empty($otherEvents);

      $this->view('event/details', [
        'event' => $featuredEvent,
        'tickets' => $tickets,
        'speakers' => $speakers,
        'is_home' => true,
        'hasOtherEvents' => $hasOtherEvents
      ]);
    } else {
      // Fallback to standard list if no highlighted event
      $events = $eventModel->getAllPublished();
      $this->view('home/index', ['events' => $events, 'title' => 'Cê Vai - Eventos e Imersões Tech']);
    }
  }

  public function list()
  {
    $eventModel = $this->model('Event');
    $featuredEvent = $eventModel->getHighlighted();

    if ($featuredEvent) {
      $events = $eventModel->getAllOthers($featuredEvent['id']);
    } else {
      $events = $eventModel->getAllPublished();
    }

    $this->view('home/index', ['events' => $events, 'title' => 'Outros Eventos - Cê Vai']);
  }
  public function contact()
  {
    $this->view('pages/contact', ['title' => 'Fale Conosco - Cê Vai']);
  }

  public function refundPolicy()
  {
    $this->view('pages/refund_policy');
  }

  public function processContact()
  {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      // 1. Honeypot Check (Anti-Spam)
      // The field 'website_check' should be left empty by humans.
      if (!empty($_POST['website_check'])) {
        // Silently fail or redirect as if success to fool bots
        $this->redirect('/contact?msg=enviado');
        return;
      }

      // 2. CSRF Check (Simple Session Token)
      if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== session_id()) {
        die('Erro de validação de segurança.');
      }

      // 3. Data Sanitization
      $name = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_SPECIAL_CHARS);
      $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
      $subject = filter_input(INPUT_POST, 'subject', FILTER_SANITIZE_SPECIAL_CHARS);
      $message = filter_input(INPUT_POST, 'message', FILTER_SANITIZE_SPECIAL_CHARS);

      if (empty($name) || empty($email) || empty($message)) {
        $this->redirect('/contact?error=campos_vazios');
        return;
      }

      // 4. Get Admin Email from Settings
      $toEmail = 'contato@cevai.com'; // Default
      if (file_exists(APP_PATH . '/models/Setting.php')) {
        require_once APP_PATH . '/models/Setting.php';
        $settingModel = new Setting();
        $settings = $settingModel->getAllAsArray();
        if (!empty($settings['contact_email'])) {
          $toEmail = $settings['contact_email'];
        }
      }

      // 5. Send Email
      require_once APP_PATH . '/core/Helpers.php';

      $emailHtml = Helpers::renderEmailView('contact_message', [
        'formName' => $name,
        'formEmail' => $email,
        'formSubject' => $subject,
        'formMessage' => $message
      ]);

      $sent = Helpers::sendEmail($toEmail, "Contato: $subject", $emailHtml);

      if ($sent) {
        $this->redirect('/contact?msg=enviado');
      } else {
        $this->redirect('/contact?error=erro_envio');
      }
    } else {
      $this->redirect('/contact');
    }
  }
}
