<?php

class Router
{
  protected $routes = [];

  public function get($path, $callback)
  {
    $this->routes['GET'][$path] = $callback;
  }

  public function post($path, $callback)
  {
    $this->routes['POST'][$path] = $callback;
  }

  public function resolve()
  {
    $path = $_SERVER['REQUEST_URI'] ?? '/';
    $method = $_SERVER['REQUEST_METHOD'];

    // Remove query string
    $position = strpos($path, '?');
    if ($position !== false) {
      $path = substr($path, 0, $position);
    }

    // Remove trailing slash if not root
    if ($path !== '/' && substr($path, -1) === '/') {
      $path = rtrim($path, '/');
    }

    // Basic matching
    $callback = $this->routes[$method][$path] ?? false;

    $logFile = dirname(__DIR__, 2) . '/debug_router.txt';
    file_put_contents($logFile, "Request: $method $path\n", FILE_APPEND);
    if ($callback === false) {
      file_put_contents($logFile, "No direct match found.\n", FILE_APPEND);
    } else {
      file_put_contents($logFile, "Direct match found.\n", FILE_APPEND);
    }
    $params = [];

    // If direct match failed, try regex matching
    if ($callback === false) {
      foreach ($this->routes[$method] as $route => $handler) {
        // Create regex pattern from route definition
        // Route: /event/(\S+) -> Pattern: #^/event/(\S+)$#
        $pattern = "#^" . $route . "$#";

        if (preg_match($pattern, $path, $matches)) {
          $callback = $handler;
          array_shift($matches); // remove full match
          $params = $matches; // remaining are parameters
          break;
        }
      }
    }

    if ($callback === false) {
      // 404
      http_response_code(404);
      require APP_PATH . '/views/errors/404.php';
      return;
    }

    if (is_string($callback)) {
      // Controller@action string format
      $parts = explode('@', $callback);
      $controllerName = $parts[0];
      $action = $parts[1];

      require_once APP_PATH . "/controllers/$controllerName.php";
      $controller = new $controllerName();
      call_user_func_array([$controller, $action], $params);
    } else {
      // Closure
      call_user_func_array($callback, $params);
    }
  }
}
