<?php

class EventSpeaker extends Model
{
  public function getByEventId($eventId)
  {
    $stmt = $this->conn->prepare("SELECT * FROM event_speakers WHERE event_id = :event_id ORDER BY id ASC");
    $stmt->bindValue(':event_id', $eventId);
    $stmt->execute();
    return $stmt->fetchAll();
  }

  public function create($data)
  {
    $sql = "INSERT INTO event_speakers (event_id, name, topic, image_url) VALUES (:event_id, :name, :topic, :image_url)";
    $stmt = $this->conn->prepare($sql);
    $stmt->bindValue(':event_id', $data['event_id']);
    $stmt->bindValue(':name', $data['name']);
    $stmt->bindValue(':topic', $data['topic']);
    $stmt->bindValue(':image_url', $data['image_url'] ?? null);
    return $stmt->execute();
  }

  public function deleteByEventId($eventId)
  {
    $stmt = $this->conn->prepare("DELETE FROM event_speakers WHERE event_id = :event_id");
    $stmt->bindValue(':event_id', $eventId);
    return $stmt->execute();
  }
}
