<?php

class Setting extends Model
{
  public function getAllAsArray()
  {
    $stmt = $this->conn->query("SELECT key_name, value FROM settings");
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $settings = [];
    foreach ($results as $row) {
      $settings[$row['key_name']] = $row['value'];
    }
    return $settings;
  }

  public function updateBatch($data)
  {
    $sql = "INSERT INTO settings (key_name, value) VALUES (:key, :val) 
            ON DUPLICATE KEY UPDATE value = :val_update";

    $stmt = $this->conn->prepare($sql);

    foreach ($data as $key => $val) {
      // Skip irrelevant keys if passed blindly (though controller should filter)
      $stmt->bindValue(':key', $key);
      $stmt->bindValue(':val', $val);
      $stmt->bindValue(':val_update', $val);
      $stmt->execute();
    }
    return true;
  }

  public function get($key, $default = null)
  {
    $stmt = $this->conn->prepare("SELECT value FROM settings WHERE key_name = :key");
    $stmt->bindValue(':key', $key);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res ? $res['value'] : $default;
  }
}
