<?php

class EmailService
{
  /**
   * Send Activation Email
   */
  public function sendActivation($toEmail, $userName, $token)
  {
    $activationLink = APP_URL . "/activate/$token";
    $subject = "Ative sua conta - Cê Vai";

    $body = Helpers::renderEmailView('activation', [
      'userName' => $userName,
      'activationLink' => $activationLink,
      'year' => date('Y')
    ]);

    return $this->send($toEmail, $subject, $body);
  }

  /**
   * Send Welcome Email
   */
  public function sendWelcome($toEmail, $userName)
  {
    $loginLink = APP_URL . "/login";
    $subject = "Bem-vindo ao Cê Vai!";

    $body = Helpers::renderEmailView('welcome', [
      'userName' => $userName,
      'loginLink' => $loginLink,
      'year' => date('Y')
    ]);

    return $this->send($toEmail, $subject, $body);
  }

  /**
   * Send Password Recovery Email
   */
  public function sendPasswordReset($toEmail, $userName, $token)
  {
    $resetLink = APP_URL . "/reset-password/$token";
    $subject = "Recuperação de Senha - Cê Vai";

    $body = Helpers::renderEmailView('reset_password', [
      'userName' => $userName,
      'resetLink' => $resetLink,
      'year' => date('Y')
    ]);

    return $this->send($toEmail, $subject, $body);
  }

  /**
   * Send Ticket Purchased Email
   */
  public function sendTicketPurchased($toEmail, $userName, $eventDetails, $ticketCode)
  {
    // $eventDetails should be an array: ['title', 'start_date', 'location']

    // Check if we can generate a QR code image URL (e.g., using a public API or internal generator)
    // For email, it's safer to link to the ticket view or use a simple qr server
    $qrCodeUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($ticketCode);
    $ticketLink = APP_URL . "/client/dashboard";

    $eventName = $eventDetails['title'] ?? ($eventDetails['name'] ?? 'Evento');
    $subject = "Seu ingresso para $eventName";

    $body = Helpers::renderEmailView('ticket', [
      'userName' => $userName,
      'eventName' => $eventName,
      'eventDate' => $eventDetails['start_date'] ?? null,
      'eventLocation' => $eventDetails['location'] ?? null,
      'ticketCode' => $ticketCode,
      'qrCodeUrl' => $qrCodeUrl,
      'ticketLink' => $ticketLink,
      'year' => date('Y')
    ]);

    return $this->send($toEmail, $subject, $body);
  }

  /**
   * Core Send Method
   */
  private function send($to, $subject, $body)
  {
    require_once APP_PATH . '/core/Helpers.php';
    return Helpers::sendEmail($to, $subject, $body);
  }
}
