<?php
$title = 'Novo Evento - Painel Admin';
require_once APP_PATH . '/views/partials/header.php';
?>

<div
  class="max-w-2xl mx-auto bg-white dark:bg-gray-900 p-8 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
  <div class="flex justify-between items-center mb-6">
    <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Criar Evento</h2>
    <a href="/admin/dashboard"
      class="text-gray-500 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Voltar</a>
  </div>

  <form action="/admin/events/store" method="POST" enctype="multipart/form-data" class="space-y-4">
    <?php echo Helpers::csrf_field(); ?>
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Título do Evento</label>
      <input type="text" name="title" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Slug (URL)</label>
      <input type="text" name="slug" required placeholder="ex: imersao-ia-2025"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Data de Início</label>
      <input type="datetime-local" name="start_date" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Local</label>
      <input type="text" name="location" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Status</label>
      <select name="status"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        <option value="draft">Rascunho</option>
        <option value="published">Publicado</option>
      </select>
    </div>
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">URL da Imagem de Capa</label>
      <input type="text" name="image_cover" placeholder="http://..."
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>
    <!-- Organizer -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1">Nome do Organizador</label>
        <input type="text" name="organizer_name"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1">Telefone/Whatsapp Organizador</label>
        <input type="text" name="organizer_phone"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
    </div>

    <!-- Map & Social -->
    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">URL Google Maps Embed (iframe src)</label>
      <input type="text" name="map_embed" placeholder="https://www.google.com/maps/embed?..."
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white text-sm font-mono focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>

    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-xs uppercase">Instagram (URL)</label>
        <input type="url" name="social_instagram"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-xs uppercase">LinkedIn (URL)</label>
        <input type="url" name="social_linkedin"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-xs uppercase">Site (URL)</label>
        <input type="url" name="social_website"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-xs uppercase">WhatsApp (Apenas números)</label>
        <input type="text" name="social_whatsapp" placeholder="5511999998888"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
    </div>

    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Conteúdo de Marketing (Visual)</label>
      <input type="hidden" name="marketing_content" id="marketing_content_input">
      <div id="editor-container"
        class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-b text-gray-900 dark:text-white h-64"
        style="border-top: 0"></div>
    </div>

    <!-- Speakers Section -->
    <div class="border-t border-gray-200 dark:border-gray-800 pt-6">
      <div class="flex justify-between items-center mb-4">
        <h3 class="text-xl font-bold text-gray-900 dark:text-gray-200">Congressistas / Palestrantes</h3>
        <button type="button" id="add-speaker-btn"
          class="bg-gray-100 dark:bg-gray-800 hover:bg-gray-200 dark:hover:bg-gray-700 text-gray-900 dark:text-white text-sm px-3 py-1 rounded border border-gray-300 dark:border-gray-600 transition">
          <i class="fas fa-plus mr-1"></i> Adicionar
        </button>
      </div>
      <div id="speakers-container" class="space-y-4">
        <!-- Rows will be added here by JS -->
      </div>
    </div>

    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Descrição Curta</label>
      <textarea name="description" rows="3"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none"></textarea>
    </div>

    <button type="submit"
      class="w-full bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold py-2 rounded mt-4 hover:brightness-110 transition">SALVAR
      EVENTO</button>
  </form>
</div>


<!-- Include Quill Styles -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<style>
  /* Light Mode Defaults */
  .ql-toolbar.ql-snow {
    border-color: #d1d5db;
    background: #f9fafb;
    border-top-left-radius: 0.5rem;
    border-top-right-radius: 0.5rem;
  }

  .ql-container.ql-snow {
    border-color: #d1d5db;
    background: #ffffff;
    font-family: 'Segoe UI', sans-serif;
    font-size: 1rem;
    color: #111827;
  }

  /* Dark Mode Overrides */
  .dark .ql-toolbar.ql-snow {
    border-color: #374151;
    background: #1f2937;
  }

  .dark .ql-container.ql-snow {
    border-color: #374151;
    background: #000;
    color: #fff;
  }

  /* Icons - Light */
  .ql-snow .ql-stroke {
    stroke: #374151 !important;
  }

  .ql-snow .ql-fill {
    fill: #374151 !important;
  }

  .ql-snow .ql-picker {
    color: #374151 !important;
  }

  /* Icons - Dark */
  .dark .ql-snow .ql-stroke {
    stroke: #9ca3af !important;
  }

  .dark .ql-snow .ql-fill {
    fill: #9ca3af !important;
  }

  .dark .ql-snow .ql-picker {
    color: #9ca3af !important;
  }
</style>

<!-- Include Quill Library -->
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

<script>
  // Initialize Quill
  var quill = new Quill('#editor-container', {
    theme: 'snow',
    modules: {
      toolbar: [
        [{ 'header': [1, 2, 3, false] }],
        ['bold', 'italic', 'underline', 'strike'],
        [{ 'color': [] }, { 'background': [] }],
        [{ 'list': 'ordered' }, { 'list': 'bullet' }],
        ['clean']
      ]
    }
  });

  // Sync content on submit
  document.querySelector('form').addEventListener('submit', function () {
    document.querySelector('#marketing_content_input').value = quill.root.innerHTML;
  });

  flatpickr("input[name='start_date']", {
    enableTime: true,
    dateFormat: "Y-m-d H:i",
    time_24hr: true,
    locale: "pt",
    altInput: true,
    altFormat: "d/m/Y H:i",
    theme: "dark"
  });

  // Speakers Logic
  const speakersContainer = document.getElementById('speakers-container');
  const addSpeakerBtn = document.getElementById('add-speaker-btn');
  let speakerIndex = 0;

  function addSpeakerRow() {
    const row = document.createElement('div');
    row.className = 'grid grid-cols-1 md:grid-cols-2 gap-4 items-end bg-gray-50 dark:bg-black/30 p-4 rounded border border-gray-200 dark:border-gray-800 relative group';
    row.innerHTML = `
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-xs">Nome do Palestrante</label>
        <input type="text" name="speakers[${speakerIndex}][name]" required
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
      <div class="flex gap-2">
        <div class="flex-1">
          <label class="block text-gray-700 dark:text-gray-400 mb-1 text-xs">Tema / Especialidade</label>
          <input type="text" name="speakers[${speakerIndex}][topic]" required
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
        <button type="button" class="text-red-500 hover:text-red-400 p-2" onclick="this.closest('.grid').remove()">
          <i class="fas fa-trash"></i>
        </button>
      </div>
    `;
    speakersContainer.appendChild(row);
    speakerIndex++;
  }

  addSpeakerBtn.addEventListener('click', addSpeakerRow);
</script>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>