<?php
$title = 'Nova Venda Manual - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-2xl mx-auto">
  <div class="flex items-center justify-between mb-8">
    <h2 class="text-3xl font-bold text-brand-neon">Nova Venda Manual (PDV)</h2>
    <a href="/admin/orders" class="text-gray-400 hover:text-white">Voltar</a>
  </div>

  <div class="bg-gray-900 p-8 rounded-lg border border-gray-800">
    <form action="/admin/orders/store" method="POST" class="space-y-6">

      <!-- Selection -->
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-gray-400 mb-2 font-bold">Evento</label>
          <select id="event_select" name="event_id" required
            class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none"
            onchange="updateTickets()">
            <option value="">Selecione o Evento...</option>
            <?php foreach ($data['events'] as $evt): ?>
              <option value="<?php echo $evt['id']; ?>"><?php echo htmlspecialchars($evt['title']); ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label class="block text-gray-400 mb-2 font-bold">Ingresso</label>
          <select id="ticket_select" name="ticket_id" required
            class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none"
            disabled>
            <option value="">Selecione o Evento primeiro</option>
          </select>
        </div>
      </div>

      <div>
        <label class="block text-gray-400 mb-2 font-bold">Quantidade</label>
        <input type="number" name="quantity" value="1" min="1" max="10" required
          class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none">
      </div>

      <hr class="border-gray-800">

      <!-- Client Info -->
      <h3 class="text-xl font-bold text-white mb-2">Dados do Cliente</h3>
      <p class="text-xs text-gray-500 mb-4">Se o email já existir, a venda será vinculada à conta existente.</p>

      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
          <label class="block text-gray-400 mb-2 text-sm">Nome Completo</label>
          <input type="text" name="client_name" required
            class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-400 mb-2 text-sm">Email</label>
          <input type="email" name="client_email" required
            class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-400 mb-2 text-sm">Telefone</label>
          <input type="text" name="client_phone"
            class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-400 mb-2 text-sm">CPF</label>
          <input type="text" name="client_cpf"
            class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none">
        </div>
      </div>

      <hr class="border-gray-800">

      <!-- Payment Type -->
      <div>
        <label class="block text-gray-400 mb-2 font-bold">Tipo de Venda</label>
        <div class="flex space-x-6">
          <label class="flex items-center space-x-2 cursor-pointer">
            <input type="radio" name="payment_type" value="pix_manual" checked
              class="form-radio text-brand-neon bg-gray-900 border-gray-700 focus:ring-0">
            <span class="text-white">Pago (Pix/Dinheiro)</span>
          </label>
          <label class="flex items-center space-x-2 cursor-pointer">
            <input type="radio" name="payment_type" value="courtesy"
              class="form-radio text-brand-purple bg-gray-900 border-gray-700 focus:ring-0">
            <span class="text-brand-purple font-bold">Cortesia (Grátis)</span>
          </label>
        </div>
      </div>

      <div class="pt-4">
        <button type="submit"
          class="w-full bg-green-500 text-black font-bold py-3 rounded hover:bg-green-400 transition transform hover:scale-[1.02]">
          CONFIRMAR VENDA
        </button>
      </div>
    </form>
  </div>
</div>

<script>
  // Data from PHP
  const ticketsByEvent = <?php echo json_encode($data['ticketsByEvent']); ?>;

  function updateTickets() {
    const eventId = document.getElementById('event_select').value;
    const ticketSelect = document.getElementById('ticket_select');

    ticketSelect.innerHTML = '<option value="">Selecione...</option>';

    if (!eventId || !ticketsByEvent[eventId] || ticketsByEvent[eventId].length === 0) {
      ticketSelect.disabled = true;
      return;
    }

    const tickets = ticketsByEvent[eventId];
    tickets.forEach(ticket => {
      const option = document.createElement('option');
      option.value = ticket.id;
      option.textContent = `${ticket.name} (R$ ${parseFloat(ticket.price).toFixed(2)})`;
      ticketSelect.appendChild(option);
    });

    ticketSelect.disabled = false;
  }
</script>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>