<?php
$title = 'Editar Cliente - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div
  class="max-w-2xl mx-auto bg-white dark:bg-gray-900 p-8 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
  <div class="flex justify-between items-center mb-6">
    <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Editar Cliente</h2>
    <a href="/admin/clients"
      class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Voltar</a>
  </div>

  <form action="/admin/clients/update" method="POST" class="space-y-4">
    <input type="hidden" name="id" value="<?php echo $data['client']['id']; ?>">

    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Nome Completo</label>
      <input type="text" name="name" value="<?php echo htmlspecialchars($data['client']['name']); ?>" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>

    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Email (Apenas leitura)</label>
      <input type="email" value="<?php echo htmlspecialchars($data['client']['email']); ?>" readonly
        class="w-full bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded p-3 text-gray-500 dark:text-gray-400 cursor-not-allowed">
    </div>

    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">CPF (Apenas leitura)</label>
      <input type="text" value="<?php echo htmlspecialchars($data['client']['cpf']); ?>" readonly
        class="w-full bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded p-3 text-gray-500 dark:text-gray-400 cursor-not-allowed">
    </div>

    <div>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Telefone</label>
      <input type="text" name="phone" value="<?php echo htmlspecialchars($data['client']['phone']); ?>" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>

    <div class="border-t border-gray-200 dark:border-gray-700 pt-4 mt-4">
      <h3 class="text-gray-900 dark:text-white font-bold mb-2">Alterar Senha (Opcional)</h3>
      <label class="block text-gray-700 dark:text-gray-400 mb-1">Nova Senha</label>
      <input type="password" name="password" placeholder="Deixe em branco para manter a atual"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
    </div>

    <div class="flex justify-end space-x-4 pt-4">
      <button type="submit"
        class="px-6 py-3 bg-brand-secondary dark:bg-brand-neon text-white dark:text-black font-bold rounded hover:brightness-110">SALVAR
        ALTERAÇÕES</button>
    </div>
  </form>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>