<?php
$title = 'Editar Pedido #' . str_pad($data['order']['id'], 5, '0', STR_PAD_LEFT) . ' - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-2xl mx-auto">
  <div class="flex items-center justify-between mb-8">
    <h2 class="text-3xl font-bold text-brand-neon">Editar Pedido</h2>
    <a href="/admin/order?id=<?php echo $data['order']['id']; ?>" class="text-gray-400 hover:text-white">Voltar</a>
  </div>

  <div class="bg-gray-900 p-8 rounded-lg border border-gray-800">
    <form action="/admin/orders/update" method="POST" class="space-y-6">
      <input type="hidden" name="id" value="<?php echo $data['order']['id']; ?>">

      <!-- Info Readonly -->
      <div class="grid grid-cols-2 gap-4">
        <div>
          <label class="block text-xs uppercase text-gray-500 font-bold mb-1">ID do Pedido</label>
          <div class="text-white text-lg font-mono">#<?php echo str_pad($data['order']['id'], 5, '0', STR_PAD_LEFT); ?>
          </div>
        </div>
        <div>
          <label class="block text-xs uppercase text-gray-500 font-bold mb-1">Cliente</label>
          <div class="text-white text-lg"><?php echo htmlspecialchars($data['user']['name']); ?></div>
        </div>
        <div>
          <label class="block text-xs uppercase text-gray-500 font-bold mb-1">Data</label>
          <div class="text-gray-300"><?php echo date('d/m/Y H:i', strtotime($data['order']['created_at'])); ?></div>
        </div>
        <div>
          <label class="block text-xs uppercase text-gray-500 font-bold mb-1">Total</label>
          <div class="text-brand-neon font-bold">R$
            <?php echo number_format($data['order']['total_amount'], 2, ',', '.'); ?></div>
        </div>
      </div>

      <hr class="border-gray-800">

      <!-- Status Edit -->
      <div>
        <label class="block text-gray-400 mb-2 font-bold">Status do Pagamento</label>
        <select name="payment_status"
          class="w-full bg-black border border-gray-700 text-white rounded p-3 focus:border-brand-neon outline-none">
          <option value="pending" <?php echo $data['order']['payment_status'] == 'pending' ? 'selected' : ''; ?>>Pendente
          </option>
          <option value="paid" <?php echo $data['order']['payment_status'] == 'paid' ? 'selected' : ''; ?>>Pago (Aprovado)
          </option>
          <option value="cancelled" <?php echo $data['order']['payment_status'] == 'cancelled' ? 'selected' : ''; ?>>
            Cancelado</option>
        </select>
        <p class="text-xs text-yellow-500 mt-2">⚠ Alterar para "Pago" irá liberar os ingressos para o usuário, mas não
          processa transações bancárias reais.</p>
      </div>

      <div class="pt-4">
        <button type="submit"
          class="w-full bg-brand-neon text-black font-bold py-3 rounded hover:bg-cyan-400 transition">
          SALVAR ALTERAÇÕES
        </button>
      </div>
    </form>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>