<?php
$title = 'Gerenciar Eventos - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-6xl mx-auto">
  <div class="flex items-center justify-between mb-8">
    <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Eventos</h2>
    <a href="/admin/events/create"
      class="bg-brand-secondary dark:bg-brand-neon text-white dark:text-black px-6 py-2 rounded font-bold hover:brightness-110">Criar
      Novo Evento</a>
  </div>

  <?php if (isset($_GET['msg'])): ?>
    <?php if ($_GET['msg'] == 'evento_excluido'): ?>
      <div class="bg-green-500/20 text-green-400 p-4 rounded mb-6 border border-green-500/30">Evento excluído com sucesso!
      </div>
    <?php elseif ($_GET['msg'] == 'erro_evento_com_vendas'): ?>
      <div class="bg-red-500/20 text-red-400 p-4 rounded mb-6 border border-red-500/30">
        <strong>Não foi possível excluir!</strong> Este evento possui ingressos vendidos ou cortesias emitidas.
      </div>
    <?php elseif ($_GET['msg'] == 'erro_ao_excluir'): ?>
      <div class="bg-red-500/20 text-red-400 p-4 rounded mb-6 border border-red-500/30">Erro desconhecido ao excluir evento.
      </div>
    <?php else: ?>
      <div class="bg-blue-500/20 text-blue-400 p-4 rounded mb-6 border border-blue-500/30">
        Mensagem do Sistema: <?php echo htmlspecialchars($_GET['msg']); ?>
      </div>
    <?php endif; ?>
  <?php endif; ?>

  <div
    class="bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-800 overflow-x-auto shadow-sm dark:shadow-none">
    <table class="w-full text-left">
      <thead>
        <tr class="bg-gray-100 dark:bg-gray-800 text-gray-600 dark:text-gray-400">
          <th class="p-4">Evento</th>
          <th class="p-4">Data</th>
          <th class="p-4">Local</th>
          <th class="p-4">Status</th>
          <th class="p-4 text-right">Ações</th>
        </tr>
      </thead>
      <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
        <?php if (empty($data['events'])): ?>
          <tr>
            <td colspan="5" class="p-8 text-center text-gray-500">Nenhum evento encontrado.</td>
          </tr>
        <?php else: ?>
          <?php foreach ($data['events'] as $event): ?>
            <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50">
              <td class="p-4 font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($event['title']); ?></td>
              <td class="p-4 text-gray-500 dark:text-gray-400">
                <?php echo date('d/m/Y H:i', strtotime($event['start_date'])); ?>
              </td>
              <td class="p-4 text-gray-500 dark:text-gray-400"><?php echo htmlspecialchars($event['location']); ?></td>
              <td class="p-4">
                <span
                  class="px-2 py-1 rounded text-xs uppercase font-bold <?php echo $event['status'] == 'published' ? 'bg-green-100 dark:bg-green-500/20 text-green-700 dark:text-green-400' : 'bg-yellow-100 dark:bg-yellow-500/20 text-yellow-700 dark:text-yellow-400'; ?>">
                  <?php echo $event['status'] == 'published' ? 'Publicado' : 'Rascunho'; ?>
                </span>
              </td>
              <td class="p-4 text-right space-x-2">
                <a href="/admin/events/highlight?id=<?php echo $event['id']; ?>"
                  class="text-lg hover:scale-110 transition inline-block text-gray-400 hover:text-yellow-400"
                  title="Definir como Principal">
                  <?php if (!empty($event['is_highlight'])): ?>
                    <span class="text-yellow-400">★</span>
                  <?php else: ?>
                    ☆
                  <?php endif; ?>
                </a>
                <a href="/admin/events/tickets?id=<?php echo $event['id']; ?>"
                  class="text-brand-purple hover:underline text-sm">Ingressos</a>
                <a href="/admin/events/edit?id=<?php echo $event['id']; ?>"
                  class="text-blue-400 hover:underline text-sm">Editar</a>
                <a href="/admin/events/operators?id=<?php echo $event['id']; ?>"
                  class="text-purple-500 hover:underline text-sm" title="Gerenciar Operadores">
                  <i class="fas fa-users-cog"></i> Ops
                </a>
                <a href="/admin/events/remove?id=<?php echo $event['id']; ?>" class="text-red-500 hover:underline text-sm"
                  onclick="return confirm('Tem certeza que deseja excluir este evento?');">Excluir</a>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>