<?php
$title = 'Gerenciar Ingressos - ' . htmlspecialchars($event['title']);
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto">
  <div class="flex justify-between items-center mb-6">
    <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Ingressos:
      <?php echo htmlspecialchars($event['title']); ?>
    </h2>
    <a href="/admin/events"
      class="text-gray-500 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Voltar</a>
  </div>

  <?php if (isset($_GET['msg'])): ?>
    <?php if ($_GET['msg'] == 'ingresso_excluido'): ?>
      <div class="bg-green-500/20 text-green-400 p-4 rounded mb-6 border border-green-500/30">Ingresso excluído com sucesso!
      </div>
    <?php elseif ($_GET['msg'] == 'erro_ingresso_com_vendas'): ?>
      <div class="bg-red-500/20 text-red-400 p-4 rounded mb-6 border border-red-500/30">
        <strong>Erro:</strong> Este tipo de ingresso já possui vendas e não pode ser excluído. Desative-o na edição.
      </div>
    <?php endif; ?>
  <?php endif; ?>

  <div
    class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 mb-8 shadow-sm dark:shadow-none">
    <h3 class="text-xl font-bold mb-4 text-gray-900 dark:text-white">Adicionar Novo Tipo de Ingresso</h3>
    <form action="/admin/events/tickets/store" method="POST" class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <?php echo Helpers::csrf_field(); ?>
      <input type="hidden" name="event_id" value="<?php echo $event['id']; ?>">

      <div class="col-span-2">
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Nome do Ingresso</label>
        <input type="text" name="name" required placeholder="Ex: Pista Premium"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>
      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Lote</label>
        <input type="text" name="batch_name" placeholder="Ex: 1º Lote"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>

      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Quantidade Total</label>
        <input type="number" name="total_quantity" required
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
      </div>

      <div>
        <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Tipo de Ingresso</label>
        <select name="is_free" id="ticketType" onchange="togglePriceFields()"
          class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
          <option value="0">Pago</option>
          <option value="1">Gratuito</option>
        </select>
      </div>
      <div><!-- Spacer --></div>

      <div id="priceFields" class="contents">
        <div>
          <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Preço Normal (R$)</label>
          <input type="number" step="0.01" name="price" id="priceInput" required
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Preço Promocional (R$)</label>
          <input type="number" step="0.01" name="promotional_price"
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Início da Promoção</label>
          <input type="datetime-local" name="promotion_start_date"
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
        <div>
          <label class="block text-gray-700 dark:text-gray-400 mb-1 text-sm">Fim da Promoção</label>
          <input type="datetime-local" name="promotion_end_date"
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
        </div>
      </div>

      <script>
        function togglePriceFields() {
          const type = document.getElementById('ticketType').value;
          const priceFields = document.getElementById('priceFields');
          const priceInput = document.getElementById('priceInput');

          if (type === '1') { // Free
            priceFields.style.display = 'none';
            priceInput.value = '0';
            priceInput.required = false;
          } else { // Paid
            priceFields.style.display = 'contents';
            priceInput.required = true;
          }
        }
      </script>

      <div class="col-span-2">
        <button type="submit"
          class="w-full bg-brand-secondary dark:bg-brand-purple text-white font-bold py-3 rounded hover:brightness-110 transition">CRIAR
          INGRESSO</button>
      </div>
    </form>
  </div>

  <!-- List TIckets -->
  <div class="space-y-4">
    <?php foreach ($ticketTypes as $ticket): ?>
      <div
        class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 p-4 rounded flex justify-between items-center shadow-sm dark:shadow-none">
        <div>
          <h4 class="font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($ticket['name']); ?></h4>
          <span
            class="text-xs text-brand-secondary dark:text-brand-purple bg-brand-secondary/10 dark:bg-brand-purple/10 px-1 rounded"><?php echo htmlspecialchars($ticket['batch_name']); ?></span>
          <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Qtd: <?php echo $ticket['total_quantity']; ?></p>
        </div>
        <div class="text-right">
          <?php if ($ticket['price'] == 0): ?>
            <p class="text-brand-secondary dark:text-brand-neon font-bold">GRATUITO</p>
          <?php else: ?>
            <p class="text-gray-900 dark:text-white font-bold">R$
              <?php echo number_format($ticket['price'], 2, ',', '.'); ?>
            </p>
            <?php if ($ticket['promotional_price']): ?>
              <p class="text-xs text-green-400">Promo: R$
                <?php echo number_format($ticket['promotional_price'], 2, ',', '.'); ?>
              </p>
            <?php endif; ?>
          <?php endif; ?>

          <!-- Edit Button -->
          <a href="/admin/events/tickets/edit?id=<?php echo $ticket['id']; ?>"
            class="text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-white text-xs mt-2 inline-block mr-2">Editar</a>

          <!-- Delete Button -->
          <a href="/admin/events/tickets/delete?id=<?php echo $ticket['id']; ?>"
            class="text-red-500 hover:text-red-400 text-xs mt-2 inline-block"
            onclick="return confirm('Tem certeza? Se houver vendas, não será permitido.');">Excluir</a>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>