<?php
$title = 'Detalhes do Pedido #' . $data['order']['id'] . ' - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto">
  <div class="flex items-center justify-between mb-8">
    <h2 class="text-3xl font-bold text-brand-neon">Pedido #<?php echo $data['order']['id']; ?></h2>
    <div class="flex items-center space-x-4">
      <a href="/admin/orders/edit?id=<?php echo $data['order']['id']; ?>"
        class="bg-blue-600 hover:bg-blue-500 text-white px-4 py-2 rounded text-sm font-bold transition">Editar
        Status</a>

      <form action="/admin/order/resend_email" method="POST"
        onsubmit="return confirm('Reenviar email com os ingressos para o cliente?');">
        <input type="hidden" name="order_id" value="<?php echo $data['order']['id']; ?>">
        <button type="submit"
          class="bg-brand-purple hover:bg-purple-500 text-white px-4 py-2 rounded text-sm font-bold transition">Reenviar
          Email</button>
      </form>

      <a href="/admin/dashboard"
        class="text-gray-500 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white border border-gray-300 dark:border-gray-700 px-4 py-2 rounded text-sm font-bold transition">Voltar</a>
    </div>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
    <!-- Info Cliente -->
    <div
      class="bg-white dark:bg-gray-900 rounded-lg p-6 border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
      <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-4">Cliente</h3>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">Nome:</strong>
        <?php echo htmlspecialchars($data['user']['name']); ?></p>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">Email:</strong>
        <?php echo htmlspecialchars($data['user']['email']); ?></p>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">Telefone:</strong>
        <?php echo htmlspecialchars($data['user']['phone'] ?? '-'); ?></p>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">CPF:</strong>
        <?php echo htmlspecialchars($data['user']['cpf'] ?? '-'); ?></p>

      <?php if (!empty($data['user']['phone'])): ?>
        <?php $phoneCleanDetails = preg_replace('/[^0-9]/', '', $data['user']['phone']); ?>
        <a href="https://wa.me/55<?php echo $phoneCleanDetails; ?>" target="_blank"
          class="mt-4 inline-flex items-center bg-green-500 hover:bg-green-600 text-white px-3 py-2 rounded text-sm font-bold transition">
          <i class="fab fa-whatsapp mr-2"></i> Contatar no WhatsApp
        </a>
      <?php endif; ?>
    </div>

    <!-- Info Pagamento -->
    <div
      class="bg-white dark:bg-gray-900 rounded-lg p-6 border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
      <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-4">Pagamento</h3>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">Método:</strong>
        <?php echo ucfirst($data['order']['payment_method']); ?></p>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">Status:</strong>
        <span
          class="px-2 py-1 rounded text-xs uppercase font-bold <?php echo $data['order']['payment_status'] == 'paid' ? 'bg-green-100 dark:bg-green-500/20 text-green-600 dark:text-green-400' : 'bg-yellow-100 dark:bg-yellow-500/20 text-yellow-600 dark:text-yellow-400'; ?>">
          <?php echo $data['order']['payment_status']; ?>
        </span>
      </p>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">Total:</strong> <span
          class="text-brand-secondary dark:text-brand-neon font-bold">R$
          <?php echo number_format($data['order']['total_amount'], 2, ',', '.'); ?></span></p>
      <p class="text-gray-600 dark:text-gray-300"><strong class="text-gray-900 dark:text-gray-500">Data:</strong>
        <?php echo date('d/m/Y H:i', strtotime($data['order']['created_at'])); ?></p>
    </div>
  </div>

  <!-- Ingressos -->
  <div
    class="bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-800 overflow-hidden shadow-sm dark:shadow-none">
    <div class="p-4 border-b border-gray-200 dark:border-gray-800">
      <h3 class="text-xl font-bold text-gray-900 dark:text-white">Ingressos Comprados</h3>
    </div>
    <table class="w-full text-left">
      <thead>
        <tr class="bg-gray-100 dark:bg-gray-800 text-gray-600 dark:text-gray-400">
          <th class="p-4">Evento</th>
          <th class="p-4">Ingresso</th>
          <th class="p-4">Preço Pago</th>
          <th class="p-4">Código (QR)</th>
          <th class="p-4">Status</th>
        </tr>
      </thead>
      <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
        <?php foreach ($data['items'] as $item): ?>
          <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50">
            <td class="p-4 text-gray-900 dark:text-white"><?php echo htmlspecialchars($item['event_title']); ?></td>
            <td class="p-4 text-gray-600 dark:text-gray-300"><?php echo htmlspecialchars($item['ticket_name']); ?></td>
            <td class="p-4 text-gray-600 dark:text-gray-300">R$
              <?php echo number_format($item['price_paid'] ?? 0, 2, ',', '.'); ?>
            </td>
            <td class="p-4 text-mono text-brand-secondary dark:text-brand-purple"><?php echo $item['unique_code']; ?></td>
            <td class="p-4">
              <span class="<?php echo $item['status'] == 'active' ? 'text-green-400' : 'text-red-400'; ?>">
                <?php echo $item['status'] == 'active' ? 'Ativo' : 'Usado'; ?>
              </span>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>