<?php
$title = 'Gerenciar Pedidos - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-6xl mx-auto">
  <div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-brand-neon">Gerenciar Pedidos</h2>
    <div class="space-x-4">
      <a href="/admin/orders/create"
        class="bg-green-500 text-white dark:text-black px-4 py-2 rounded font-bold hover:bg-green-600 dark:hover:bg-green-400 transition shadow-lg hover:shadow-green-500/20">
        <i class="fas fa-cash-register mr-2"></i>Nova Venda (PDV)
      </a>
      <a href="/admin/dashboard"
        class="text-gray-500 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Voltar</a>
    </div>
  </div>

  <div
    class="bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-800 overflow-x-auto shadow-sm dark:shadow-none">
    <table class="w-full text-left">
      <thead>
        <tr class="bg-gray-100 dark:bg-gray-800 text-gray-600 dark:text-gray-400">
          <th class="p-4">ID</th>
          <th class="p-4">Cliente</th>
          <th class="p-4">Evento</th>
          <th class="p-4">Valor</th>
          <th class="p-4">Data</th>
          <th class="p-4">Status</th>
          <th class="p-4 text-right">Ações</th>
        </tr>
      </thead>
      <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
        <?php if (empty($data['orders'])): ?>
          <tr>
            <td colspan="7" class="p-8 text-center text-gray-500">Nenhum pedido encontrado.</td>
          </tr>
        <?php else: ?>
          <?php foreach ($data['orders'] as $order): ?>
            <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50">
              <td class="p-4 font-mono text-brand-secondary dark:text-brand-neon">
                #<?php echo str_pad($order['id'], 5, '0', STR_PAD_LEFT); ?></td>
              <td class="p-4 text-gray-900 dark:text-white font-bold">
                <?php echo htmlspecialchars($order['user_name']); ?>
                <?php if (!empty($order['user_phone'])): ?>
                  <?php
                  $phoneClean = preg_replace('/[^0-9]/', '', $order['user_phone']);
                  if (strlen($phoneClean) >= 10): // Basic validation
                    ?>
                    <a href="https://wa.me/55<?php echo $phoneClean; ?>" target="_blank"
                      class="ml-2 text-green-500 hover:text-green-600" title="Contatar via WhatsApp">
                      <i class="fab fa-whatsapp"></i>
                    </a>
                  <?php endif; ?>
                <?php endif; ?>
              </td>
              <td class="p-4 text-gray-600 dark:text-gray-300"><?php echo htmlspecialchars($order['event_title']); ?></td>
              <td class="p-4 text-gray-900 dark:text-white">R$
                <?php echo number_format($order['total_amount'], 2, ',', '.'); ?>
              </td>
              <td class="p-4 text-gray-500 text-sm"><?php echo date('d/m/y H:i', strtotime($order['created_at'])); ?></td>
              <td class="p-4">
                <?php
                $statusLabel = 'Pendente';
                $statusClass = 'bg-yellow-500/10 text-yellow-500';

                if ($order['payment_status'] === 'paid') {
                  $statusLabel = 'Pago';
                  $statusClass = 'bg-green-500/10 text-green-500';
                } elseif ($order['payment_status'] === 'cancelled') {
                  $statusLabel = 'Cancelado';
                  $statusClass = 'bg-red-500/10 text-red-500';
                }
                ?>
                <span class="px-2 py-1 rounded text-xs font-bold <?php echo $statusClass; ?>">
                  <?php echo $statusLabel; ?>
                </span>
              </td>
              <td class="p-4 text-right">
                <a href="/admin/order?id=<?php echo $order['id']; ?>"
                  class="text-brand-secondary dark:text-brand-purple hover:underline text-sm font-bold">Detalhes</a>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>