<?php
$title = 'Relatórios de Vendas - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-6xl mx-auto">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Relatórios</h2>
    </div>

    <!-- Filters & Actions -->
    <div
        class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 mb-8 shadow-sm dark:shadow-none">
        <form action="/admin/reports" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">

            <!-- Event Selector -->
            <div>
                <label class="block text-xs text-gray-700 dark:text-gray-400 mb-1 uppercase font-bold">Evento</label>
                <select name="event_id" onchange="this.form.submit()"
                    class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
                    <option value="">Todos os Eventos</option>
                    <?php foreach ($events as $evt): ?>
                        <option value="<?php echo $evt['id']; ?>" <?php echo ($filters['event_id'] ?? '') == $evt['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($evt['title']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- Ticket Selector (Dependent on Event) -->
            <div>
                <label class="block text-xs text-gray-700 dark:text-gray-400 mb-1 uppercase font-bold">Ingresso</label>
                <select name="ticket_id" <?php echo empty($tickets) ? 'disabled' : ''; ?>
                    class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon outline-none disabled:opacity-50 disabled:cursor-not-allowed">
                    <option value="">Todos os Ingressos</option>
                    <?php if (!empty($tickets)): ?>
                        <?php foreach ($tickets as $tkt): ?>
                            <option value="<?php echo $tkt['id']; ?>" <?php echo ($filters['ticket_id'] ?? '') == $tkt['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($tkt['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </select>
            </div>

            <!-- Report Type Selector -->
            <div>
                <label class="block text-xs text-gray-700 dark:text-gray-400 mb-1 uppercase font-bold">Tipo de
                    Relatório</label>
                <select name="type"
                    class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 text-gray-900 dark:text-white rounded p-2 focus:border-brand-secondary dark:focus:border-brand-neon outline-none">
                    <option value="sales" <?php echo ($filters['type'] ?? '') == 'sales' ? 'selected' : ''; ?>>Resumo de
                        Vendas</option>
                    <option value="attendees" <?php echo ($filters['type'] ?? '') == 'attendees' ? 'selected' : ''; ?>>
                        Lista de Participantes</option>
                </select>
            </div>

            <!-- Filter Button -->
            <div>
                <button type="submit"
                    class="w-full bg-brand-secondary dark:bg-brand-purple hover:brightness-110 text-white font-bold py-2 px-4 rounded transition">
                    Filtrar
                </button>
            </div>

            <!-- Export Buttons -->
            <div class="flex space-x-2">
                <?php
                $csvLink = '/admin/reports/export?' . http_build_query(array_merge($filters, ['format' => 'csv']));
                $pdfLink = '/admin/reports/export?' . http_build_query(array_merge($filters, ['format' => 'pdf']));
                ?>
                <a href="<?php echo $csvLink; ?>" target="_blank"
                    class="flex-1 flex items-center justify-center bg-gray-100 dark:bg-gray-800 hover:bg-gray-200 dark:hover:bg-gray-700 text-brand-secondary dark:text-brand-neon font-bold py-2 px-2 rounded border border-gray-300 dark:border-gray-700 transition text-sm">
                    CSV
                </a>
                <a href="<?php echo $pdfLink; ?>" target="_blank"
                    class="flex-1 flex items-center justify-center bg-gray-100 dark:bg-gray-800 hover:bg-gray-200 dark:hover:bg-gray-700 text-brand-secondary dark:text-brand-neon font-bold py-2 px-2 rounded border border-gray-300 dark:border-gray-700 transition text-sm">
                    PDF
                </a>
            </div>
        </form>
    </div>

    <!-- Report Data -->
    <div
        class="bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-800 overflow-hidden shadow-sm dark:shadow-none">
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead class="bg-gray-100 dark:bg-gray-950 text-gray-500 uppercase font-bold text-xs">
                    <tr>
                        <?php if ($filters['type'] == 'sales'): ?>
                            <?php if (!empty($filters['event_id'])): ?>
                                <th class="p-4">Tipo de Ingresso</th>
                                <th class="p-4">Quantidade</th>
                                <th class="p-4">Receita</th>
                            <?php else: ?>
                                <th class="p-4">Evento</th>
                                <th class="p-4">Pedidos Pagos</th>
                                <th class="p-4">Receita Gerada</th>
                                <th class="p-4 px-6 text-right">Ações</th>
                            <?php endif; ?>
                        <?php else: // attendees ?>
                            <th class="p-4">Nome</th>
                            <th class="p-4">Email</th>
                            <th class="p-4">Ingresso</th>
                            <th class="p-4">Código</th>
                            <th class="p-4">Data Compra</th>
                            <th class="p-4">Status</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-800">
                    <?php if (empty($reportData)): ?>
                        <tr>
                            <td colspan="6" class="p-8 text-center text-gray-500">
                                <?php echo $filters['type'] == 'attendees' && empty($filters['event_id']) ? 'Selecione um evento para ver a lista de participantes.' : 'Nenhum dado encontrado.'; ?>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($reportData as $row): ?>
                            <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50">
                                <?php if ($filters['type'] == 'sales'): ?>
                                    <?php if (!empty($filters['event_id'])): ?>
                                        <td class="p-4 text-gray-900 dark:text-white font-bold">
                                            <?php echo htmlspecialchars($row['name']); ?>
                                        </td>
                                        <td class="p-4 text-gray-600 dark:text-gray-400"><?php echo $row['count']; ?></td>
                                        <td class="p-4 text-green-600 dark:text-green-400 font-bold">R$
                                            <?php echo number_format($row['revenue'] ?? 0, 2, ',', '.'); ?>
                                        </td>
                                    <?php else: ?>
                                        <td class="p-4 font-bold text-gray-900 dark:text-white">
                                            <?php echo htmlspecialchars($row['title']); ?>
                                        </td>
                                        <td class="p-4 text-gray-600 dark:text-gray-400"><?php echo $row['total_orders']; ?></td>
                                        <td class="p-4 text-green-600 dark:text-green-400 font-bold">R$
                                            <?php echo number_format($row['total_revenue'] ?? 0, 2, ',', '.'); ?>
                                        </td>
                                        <td class="p-4 text-right">
                                            <a href="/admin/reports?event_id=<?php echo $row['id']; ?>&type=sales"
                                                class="text-brand-secondary dark:text-brand-purple hover:underline text-sm mr-2">Detalhar</a>
                                        </td>
                                    <?php endif; ?>
                                <?php else: // attendees ?>
                                    <td class="p-4 text-gray-900 dark:text-white font-bold">
                                        <?php echo htmlspecialchars($row['user_name']); ?>
                                    </td>
                                    <td class="p-4 text-gray-600 dark:text-gray-400">
                                        <?php echo htmlspecialchars($row['user_email']); ?>
                                    </td>
                                    <td class="p-4 text-gray-600 dark:text-gray-300">
                                        <?php echo htmlspecialchars($row['ticket_name']); ?>
                                    </td>
                                    <td class="p-4 font-mono text-brand-secondary dark:text-brand-neon text-xs">
                                        <?php echo $row['unique_code']; ?>
                                    </td>
                                    <td class="p-4 text-gray-500 text-sm">
                                        <?php echo date('d/m/y H:i', strtotime($row['purchase_date'])); ?>
                                    </td>
                                    <td class="p-4">
                                        <span
                                            class="px-2 py-1 rounded text-xs font-bold <?php echo $row['status'] == 'active' ? 'text-green-500 bg-green-500/10' : 'text-gray-500 bg-gray-500/10'; ?>">
                                            <?php echo $row['status'] == 'active' ? 'Ativo' : 'Utilizado'; ?>
                                        </span>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>