<?php
$title = 'Recuperar Senha - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="min-h-[calc(100vh-64px)] flex items-center justify-center relative overflow-hidden py-12 px-4">

  <!-- Background Decoration -->
  <div class="absolute top-0 left-0 w-full h-full overflow-hidden z-0 pointer-events-none">
    <div class="absolute top-[-20%] left-[-10%] w-[500px] h-[500px] rounded-full bg-brand-secondary/10 blur-[100px]">
    </div>
    <div class="absolute bottom-[-20%] right-[-10%] w-[500px] h-[500px] rounded-full bg-brand-neon/10 blur-[100px]">
    </div>
  </div>

  <div
    class="w-full max-w-md bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 p-8 rounded-xl shadow-2xl relative z-10 transition-colors duration-300">
    <div class="text-center mb-8">
      <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">Recuperar Senha</h1>
      <p class="text-gray-600 dark:text-gray-400 text-sm">Digite seu e-mail para receber as instruções.</p>
    </div>

    <?php if (isset($error)): ?>
      <div
        class="bg-red-100 dark:bg-red-500/10 border border-red-200 dark:border-red-500/50 text-red-600 dark:text-red-500 text-sm p-3 rounded mb-6 text-center">
        <?php echo $error; ?>
      </div>
    <?php endif; ?>

    <?php if (isset($success)): ?>
      <div
        class="bg-green-100 dark:bg-green-500/10 border border-green-200 dark:border-green-500/50 text-green-600 dark:text-green-500 text-sm p-3 rounded mb-6 text-center">
        <?php echo $success; ?>
      </div>
    <?php endif; ?>

    <form action="/forgot-password" method="POST" class="space-y-6">
      <div>
        <label class="block text-sm font-medium text-gray-700 dark:text-gray-400 mb-1">E-mail</label>
        <div class="relative">
          <span class="absolute left-3 top-3 text-gray-500"><i class="fas fa-envelope"></i></span>
          <input type="email" name="email" required placeholder="seu@email.com"
            class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded pl-10 pr-4 py-3 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon focus:ring-1 focus:ring-brand-secondary dark:focus:ring-brand-neon outline-none transition">
        </div>
      </div>

      <button type="submit"
        class="w-full py-3 rounded-xl font-bold uppercase tracking-wider shadow-lg bg-brand-neon text-black hover:bg-brand-secondary hover:text-white transition-all duration-300 transform hover:-translate-y-1 hover:shadow-brand-neon/40">
        Enviar Link de Recuperação
      </button>
    </form>

    <p class="text-center text-gray-600 dark:text-gray-500 text-sm mt-6">
      Lembrou a senha? <a href="/login"
        class="text-brand-secondary dark:text-brand-neon hover:underline font-bold">Entrar</a>
    </p>
  </div>

</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>