<?php
$title = 'Nova Senha - Cê Vai';
$siteName = 'CÊ VAI';
$siteLogo = '';

try {
  if (file_exists(APP_PATH . '/models/Setting.php')) {
    require_once APP_PATH . '/models/Setting.php';
    if (class_exists('Setting')) {
      $settingModel = new Setting();
      $settings = $settingModel->getAllAsArray();
      if (!empty($settings['site_name']))
        $siteName = $settings['site_name'];
      if (!empty($settings['site_logo']))
        $siteLogo = $settings['site_logo'];
    }
  }
} catch (Exception $e) {
}
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo $title; ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            brand: {
              dark: '#0a0a0a',
              neon: '<?php echo $settings['color_brand_neon'] ?? '#00F3FF'; ?>',
              secondary: '<?php echo $settings['color_brand_secondary'] ?? '#7000FF'; ?>'
            }
          }
        }
      }
    }
  </script>
  <style>
    body {
      background-color: #0a0a0a;
      color: #fff;
      font-family: 'Inter', sans-serif;
    }
  </style>
</head>

<body class="bg-brand-dark min-h-screen flex items-center justify-center relative overflow-hidden">

  <!-- Background Decoration -->
  <div class="absolute top-0 left-0 w-full h-full overflow-hidden z-0 pointer-events-none">
    <div class="absolute top-[-20%] left-[-10%] w-[500px] h-[500px] rounded-full bg-brand-neon opacity-10 blur-[100px]">
    </div>
    <div
      class="absolute bottom-[-20%] right-[-10%] w-[500px] h-[500px] rounded-full bg-brand-secondary opacity-10 blur-[100px]">
    </div>
  </div>

  <div class="w-full max-w-md bg-gray-900 border border-gray-800 p-8 rounded-xl shadow-2xl relative z-10 glass-effect">
    <div class="text-center mb-8">
      <?php if ($siteLogo): ?>
        <img src="<?php echo htmlspecialchars($siteLogo); ?>" alt="<?php echo htmlspecialchars($siteName); ?>"
          class="h-16 mx-auto mb-4 object-contain">
      <?php else: ?>
        <h1
          class="text-3xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-brand-neon to-brand-secondary italic">
          <?php echo htmlspecialchars($siteName); ?>
        </h1>
      <?php endif; ?>
      <p class="text-gray-400 mt-2">Definir Nova Senha</p>
    </div>

    <?php if (isset($error)): ?>
      <div class="bg-red-500/10 border border-red-500/50 text-red-500 text-sm p-3 rounded mb-6 text-center">
        <?php echo $error; ?>
      </div>
    <?php endif; ?>

    <form action="/reset-password" method="POST" class="space-y-6">
      <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">

      <div>
        <label class="block text-sm font-medium text-gray-400 mb-1">Nova Senha</label>
        <div class="relative">
          <span class="absolute left-3 top-3 text-gray-500"><i class="fas fa-lock"></i></span>
          <input type="password" name="password" required placeholder="Nova senha"
            class="w-full bg-black border border-gray-700 rounded pl-10 pr-4 py-3 text-white focus:border-brand-neon focus:ring-1 focus:ring-brand-neon outline-none transition">
        </div>
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-400 mb-1">Confirmar Nova Senha</label>
        <div class="relative">
          <span class="absolute left-3 top-3 text-gray-500"><i class="fas fa-lock"></i></span>
          <input type="password" name="confirm_password" required placeholder="Confirme a senha"
            class="w-full bg-black border border-gray-700 rounded pl-10 pr-4 py-3 text-white focus:border-brand-neon focus:ring-1 focus:ring-brand-neon outline-none transition">
        </div>
      </div>

      <button type="submit"
        class="w-full bg-brand-neon hover:bg-cyan-400 text-black font-bold py-3 rounded transition shadow-lg hover:shadow-brand-neon/20">
        Alterar Senha
      </button>
    </form>
  </div>

</body>

</html>