<?php require APP_PATH . '/views/partials/header.php'; ?>

<main class="container my-5">
  <div class="row justify-content-center">
    <div class="col-md-8 col-lg-6">
      <div class="card shadow-sm border-0 rounded-3">
        <div class="card-body text-center p-5">

          <?php if (isset($type) && $type === 'success'): ?>
            <div class="mb-4">
              <i class="bi bi-check-circle-fill text-success" style="font-size: 4rem;"></i>
            </div>
          <?php else: ?>
            <div class="mb-4">
              <i class="bi bi-exclamation-triangle-fill text-warning" style="font-size: 4rem;"></i>
            </div>
          <?php endif; ?>

          <h2 class="card-title fw-bold mb-3"><?= $title ?? 'Aviso' ?></h2>

          <p class="card-text text-muted mb-4" style="font-size: 1.1rem;">
            <?= $message ?? '' ?>
          </p>

          <?php if (isset($action_url)): ?>
            <a href="<?= $action_url ?>" class="btn btn-primary btn-lg px-5 rounded-pill">
              <?= $action_text ?? 'Voltar' ?>
            </a>
          <?php else: ?>
            <a href="javascript:history.back()" class="btn btn-outline-secondary btn-lg px-5 rounded-pill">
              Voltar
            </a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</main>

<?php require APP_PATH . '/views/partials/footer.php'; ?>