<?php
$title = 'Pagamento - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-xl mx-auto py-12 px-4">
  <div class="bg-gray-900 border border-gray-800 rounded-lg p-8 text-center">
    <h2 class="text-2xl font-bold text-white mb-2">Pagamento via Pix</h2>
    <p class="text-gray-400 mb-6">Escaneie o QR Code ou copie o código abaixo.</p>

    <div class="bg-white p-4 inline-block rounded-lg mb-6">
      <img src="data:image/png;base64,<?php echo $payment['pixEncodedImage']; ?>" alt="QR Code Pix" class="w-48 h-48">
    </div>

    <div class="mb-6">
      <label class="block text-xs text-gray-500 uppercase mb-2">Pix Copia e Cola</label>
      <div class="flex gap-2">
        <input type="text" id="pixCode" value="<?php echo $payment['pixQrCode']; ?>" readonly
          class="w-full bg-black border border-gray-700 text-gray-300 text-sm rounded p-2 focus:ring-1 focus:ring-brand-neon outline-none">
        <button onclick="copyPix()"
          class="bg-gray-800 hover:bg-gray-700 text-white px-4 rounded border border-gray-700">
          Copiar
        </button>
      </div>
      <p id="copyMsg" class="text-green-500 text-xs mt-2 hidden">Copiado com sucesso!</p>
    </div>

    <div class="text-sm text-gray-500 mb-6">
      O pagamento será confirmado automaticamente em instantes.
    </div>

    <a href="/client/tickets"
      class="inline-block bg-brand-neon hover:bg-brand-neon-hover text-black font-bold py-3 px-8 rounded transition duration-200">
      Já realizei o pagamento
    </a>
  </div>
</div>

<script>
  function copyPix() {
    const copyText = document.getElementById("pixCode");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(copyText.value);

    const msg = document.getElementById('copyMsg');
    msg.classList.remove('hidden');
    setTimeout(() => msg.classList.add('hidden'), 3000);
  }
</script>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>