<?php
$title = 'Minha Conta - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto">
  <div class="flex items-center justify-between mb-8">
    <h2 class="text-3xl font-bold text-brand-secondary dark:text-brand-neon">Meus Ingressos</h2>
    <a href="/"
      class="bg-gray-200 dark:bg-gray-800 hover:bg-gray-300 dark:hover:bg-gray-700 text-gray-900 dark:text-white px-4 py-2 rounded transition">Comprar
      novos
      ingressos</a>
  </div>

  <!-- Tickets List -->
  <div
    class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 mb-8 shadow-sm dark:shadow-none">
    <?php if (empty($tickets)): ?>
      <p class="text-gray-500 text-center py-8">Você ainda não possui ingressos.</p>
    <?php else: ?>
      <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <?php foreach ($tickets as $ticket): ?>
          <div
            class="bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 p-4 rounded flex justify-between items-center group hover:border-brand-secondary dark:hover:border-brand-neon transition">
            <div>
              <h4 class="font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($ticket['event_title']); ?>
              </h4>
              <p class="text-sm text-gray-500 dark:text-gray-400"><?php echo htmlspecialchars($ticket['ticket_name']); ?>
              </p>
              <p class="text-xs text-brand-secondary dark:text-brand-neon font-mono mt-1">
                <?php if ($ticket['status'] === 'active' || $ticket['status'] === 'used'): ?>
                  #<?php echo htmlspecialchars($ticket['unique_code']); ?>
                <?php else: ?>
                  #-------
                <?php endif; ?>
              </p>

              <!-- Status Badge -->
              <!-- Status Badge -->
              <?php if ($ticket['status'] === 'pending' || $ticket['status'] === 'pending_payment'): ?>
                <span class="text-xs text-yellow-500 font-bold mt-1 block">● Aguardando Pagamento</span>
              <?php elseif ($ticket['status'] === 'cancelled'): ?>
                <span class="text-xs text-red-500 font-bold mt-1 block">● Cancelado</span>
              <?php endif; ?>
            </div>
            <div class="text-right">
              <span
                class="block text-xs uppercase text-gray-500 mb-1"><?php echo date('d/m/Y', strtotime($ticket['start_date'])); ?></span>

              <?php if ($ticket['status'] === 'active' || $ticket['status'] === 'used'): ?>
                <a href="/client/tickets/<?php echo $ticket['unique_code']; ?>/view"
                  class="text-brand-neon hover:text-white text-sm font-bold border border-brand-neon hover:bg-brand-neon hover:text-black px-3 py-1 rounded transition">
                  Ver
                </a>
              <?php elseif ($ticket['status'] === 'pending' || $ticket['status'] === 'pending_payment'): ?>
                <?php
                $createdAt = strtotime($ticket['created_at']);
                $expiryTime = $createdAt + (10 * 60);
                $timeLeft = $expiryTime - time();
                ?>
                <?php if ($timeLeft > 0): ?>
                  <div class="flex flex-col items-end">
                    <span class="text-xl font-mono font-bold text-brand-secondary dark:text-brand-neon countdown-timer mb-1"
                      data-expires="<?php echo $expiryTime; ?>">--:--</span>
                    <a href="/checkout/payment/<?php echo $ticket['order_id']; ?>"
                      class="text-xs bg-brand-secondary dark:bg-brand-neon text-white dark:text-black px-3 py-1 rounded font-bold hover:opacity-90 transition">Pagar</a>
                  </div>
                <?php else: ?>
                  <span class="text-red-500 font-bold text-sm border border-red-500/50 px-3 py-1 rounded">Expirado</span>
                <?php endif; ?>
              <?php else: ?>
                <span class="text-gray-600 text-sm font-bold border border-gray-700 px-3 py-1 rounded cursor-not-allowed">
                  Cancelado
                </span>
              <?php endif; ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>

  <h2 class="text-2xl font-bold mb-4 flex items-center text-gray-900 dark:text-white">
    <i class="fas fa-user-circle mr-3 text-brand-secondary dark:text-brand-neon"></i>Dados da Conta
  </h2>

  <div
    class="bg-white dark:bg-gray-900 p-6 rounded-lg border border-gray-200 dark:border-gray-800 shadow-sm dark:shadow-none">
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
      <div>
        <label class="block text-gray-500 dark:text-gray-500 text-xs uppercase font-bold mb-1">Nome Completo</label>
        <p class="text-gray-900 dark:text-white text-lg font-medium"><?php echo htmlspecialchars($user['name']); ?></p>
      </div>
      <div>
        <label class="block text-gray-500 dark:text-gray-500 text-xs uppercase font-bold mb-1">E-mail</label>
        <p class="text-gray-900 dark:text-white text-lg font-medium"><?php echo htmlspecialchars($user['email']); ?></p>
      </div>
      <div>
        <label class="block text-gray-500 dark:text-gray-500 text-xs uppercase font-bold mb-1">Telefone</label>
        <p class="text-gray-900 dark:text-white text-lg font-medium">
          <?php echo htmlspecialchars($user['phone'] ?? '-'); ?></p>
      </div>
      <div>
        <label class="block text-gray-500 dark:text-gray-500 text-xs uppercase font-bold mb-1">CPF</label>
        <p class="text-gray-900 dark:text-white text-lg font-medium">
          <?php echo htmlspecialchars($user['cpf'] ?? '-'); ?></p>
      </div>
      <div>
        <label class="block text-gray-500 dark:text-gray-500 text-xs uppercase font-bold mb-1">Membro Desde</label>
        <p class="text-gray-900 dark:text-white text-lg font-medium">
          <?php echo date('d/m/Y', strtotime($user['created_at'] ?? 'now')); ?>
        </p>
      </div>
    </div>

    <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-800">
      <a href="/client/profile"
        class="inline-flex items-center space-x-2 text-brand-secondary dark:text-brand-purple hover:text-gray-900 dark:hover:text-white transition group">
        <span class="font-bold">Editar Informações</span>
        <i class="fas fa-arrow-right transform group-hover:translate-x-1 transition"></i>
      </a>
    </div>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>