<?php
$title = 'Meu Perfil - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<div
  class="max-w-xl mx-auto bg-white dark:bg-gray-900 p-8 rounded-lg border border-gray-200 dark:border-gray-800 shadow-lg dark:shadow-none transition-colors duration-300">
  <h2 class="text-3xl font-bold mb-6 text-brand-secondary dark:text-brand-neon">Meu Perfil</h2>

  <?php if (isset($_GET['msg']) && $_GET['msg'] === 'atualizado'): ?>
    <div
      class="bg-green-100 dark:bg-green-500/20 border border-green-500 text-green-700 dark:text-green-100 p-3 rounded mb-4 text-sm text-center">
      Dados atualizados com sucesso!
    </div>
  <?php endif; ?>

  <form action="/client/profile/update" method="POST" class="space-y-4">
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">Nome</label>
      <input type="text" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">E-mail</label>
      <input type="email" value="<?php echo htmlspecialchars($user['email']); ?>" disabled
        class="w-full bg-gray-100 dark:bg-gray-800 border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-500 cursor-not-allowed transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">CPF</label>
      <input type="text" value="<?php echo htmlspecialchars($user['cpf']); ?>" disabled
        class="w-full bg-gray-100 dark:bg-gray-800 border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-500 cursor-not-allowed transition-colors">
    </div>
    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">Telefone</label>
      <input type="text" name="phone" value="<?php echo htmlspecialchars($user['phone'] ?? ''); ?>"
        placeholder="(00) 00000-0000"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none transition-colors">
    </div>

    <hr class="border-gray-200 dark:border-gray-800 my-4">

    <div>
      <label class="block text-gray-600 dark:text-gray-400 mb-1">Nova Senha (opcional)</label>
      <input type="password" name="password" placeholder="Deixe em branco para manter"
        class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded p-2 text-gray-900 dark:text-white focus:border-brand-secondary dark:focus:border-brand-neon outline-none transition-colors">
    </div>

    <button type="submit"
      class="w-full bg-brand-neon text-black font-bold py-3 rounded hover:brightness-110 transition mt-4 shadow-lg hover:shadow-brand-neon/40 uppercase tracking-widest">SALVAR
      ALTERAÇÕES</button>
  </form>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>