<h2>Ingresso Confirmado!</h2>
<p>Olá <strong><?php echo htmlspecialchars($userName); ?></strong>,</p>
<p>Seu pagamento foi confirmado e seu ingresso para <strong><?php echo htmlspecialchars($eventName); ?></strong> está
  garantido.</p>

<div style="background-color: #f8fafc; padding: 15px; border-radius: 8px; margin: 20px 0; text-align: left;">
  <p style="margin: 0 0 5px 0; color: #64748b; font-size: 12px; text-transform: uppercase;">Evento</p>
  <p style="margin: 0 0 15px 0; font-size: 16px; font-weight: bold; color: #0f172a;">
    <?php echo htmlspecialchars($eventName); ?></p>

  <?php if (!empty($eventDate)): ?>
    <p style="margin: 0 0 5px 0; color: #64748b; font-size: 12px; text-transform: uppercase;">Data</p>
    <p style="margin: 0 0 15px 0; font-size: 16px; color: #0f172a;">
      <?php echo date('d/m/Y \à\s H:i', strtotime($eventDate)); ?></p>
  <?php endif; ?>

  <?php if (!empty($eventLocation)): ?>
    <p style="margin: 0 0 5px 0; color: #64748b; font-size: 12px; text-transform: uppercase;">Local</p>
    <p style="margin: 0 0 0 0; font-size: 16px; color: #0f172a;"><?php echo htmlspecialchars($eventLocation); ?></p>
  <?php endif; ?>
</div>

<div
  style="background-color: #fff; border: 2px dashed #cbd5e1; padding: 20px; border-radius: 8px; text-align: center; margin: 20px 0;">
  <p style="margin: 0; font-size: 12px; text-transform: uppercase; color: #64748b;">Código do Ingresso</p>
  <p style="margin: 5px 0 15px 0; font-size: 24px; font-weight: bold; color: #0f172a; font-family: monospace;">
    <?php echo htmlspecialchars($ticketCode); ?>
  </p>

  <img src="<?php echo $qrCodeUrl; ?>" alt="QR Code" style="width: 150px; height: 150px; border: 4px solid #fff;">
</div>

<p>Apresente este QR Code na entrada do evento (pelo celular ou impresso).</p>

<div style="text-align: center;">
  <a href="<?php echo $ticketLink; ?>" class="button">VER MEUS INGRESSOS</a>
</div>