<?php
$title = htmlspecialchars($event['title']) . ' - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';
?>

<!-- Custom Animations Styles -->
<style>
  @keyframes fadeInUp {
    from {
      opacity: 0;
      transform: translateY(20px);
    }

    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  .animate-fade-in-up {
    animation: fadeInUp 0.8s ease-out forwards;
  }

  .delay-100 {
    animation-delay: 0.1s;
  }

  .delay-200 {
    animation-delay: 0.2s;
  }

  .delay-300 {
    animation-delay: 0.3s;
  }

  .glass-card {
    background: rgba(255, 255, 255, 0.03);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border: 1px solid rgba(255, 255, 255, 0.05);
  }

  html:not(.dark) .glass-card {
    background: rgba(255, 255, 255, 0.9);
    border: 1px solid rgba(0, 0, 0, 0.1);
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
  }
</style>

<!-- Hero Section with Background -->
<div class="relative w-full h-[60vh] md:h-[70vh] overflow-hidden">
  <!-- Background Image -->
  <div class="absolute inset-0 z-0">
    <img src="<?php echo htmlspecialchars($event['image_cover']); ?>" alt="Cover" class="w-full h-full object-cover">
    <div
      class="absolute inset-0 bg-gradient-to-t from-gray-100 via-gray-100/40 to-transparent dark:from-brand-dark dark:via-brand-dark/60">
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-gray-100/30 to-transparent dark:from-brand-dark/40"></div>
  </div>

  <!-- Hero Content -->
  <div class="relative z-10 container mx-auto px-4 md:px-6 h-full flex flex-col justify-end pb-16 md:pb-24">

    <?php if (!empty($is_home) && !empty($hasOtherEvents)): ?>
      <div class="absolute top-8 right-6 z-20">
        <a href="/agenda"
          class="flex items-center gap-2 bg-white/10 hover:bg-white/20 text-white backdrop-blur-md border border-white/20 px-6 py-3 rounded-full font-bold uppercase tracking-wider text-sm transition-all duration-300 hover:scale-105 shadow-lg shadow-black/20 group">
          <i class="fas fa-arrow-left group-hover:-translate-x-1 transition-transform"></i>
          <span>Outros Eventos</span>
        </a>
      </div>
    <?php endif; ?>

    <div class="max-w-4xl animate-fade-in-up">
      <div class="flex flex-wrap gap-2 mb-4">
        <span
          class="bg-brand-neon/10 border border-brand-neon/20 text-brand-secondary dark:text-brand-neon px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider backdrop-blur-sm">
          Evento Oficial
        </span>
        <?php if ($event['status'] !== 'published'): ?>
          <span
            class="bg-yellow-500/20 border border-yellow-500/30 text-yellow-600 dark:text-yellow-500 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wider backdrop-blur-sm">
            <?php echo $event['status'] == 'draft' ? 'Rascunho' : 'Privado'; ?>
          </span>
        <?php endif; ?>
      </div>

      <h1
        class="text-4xl md:text-6xl lg:text-7xl font-black text-gray-900 dark:text-white leading-tight mb-6 tracking-tight drop-shadow-sm dark:drop-shadow-2xl">
        <?php echo htmlspecialchars($event['title']); ?>
      </h1>

      <div class="flex flex-wrap items-center gap-6 text-gray-600 dark:text-gray-300 text-sm md:text-base font-medium">
        <div class="flex items-center gap-2">
          <i class="far fa-calendar text-brand-secondary dark:text-brand-neon"></i>
          <span><?php echo Helpers::formatDate($event['start_date']); ?></span>
        </div>
        <div class="flex items-center gap-2">
          <i class="far fa-clock text-brand-secondary dark:text-brand-neon"></i>
          <span><?php echo date('H:i', strtotime($event['start_date'])); ?></span>
        </div>
        <div class="flex items-center gap-2">
          <i class="fas fa-map-marker-alt text-brand-secondary dark:text-brand-neon"></i>
          <span><?php echo htmlspecialchars($event['location']); ?></span>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Main Content -->
<div class="container mx-auto px-2 md:px-6 -mt-10 relative z-20 pb-20">
  <div class="grid grid-cols-1 md:grid-cols-12 gap-8">

    <!-- Left Column: Details (8 cols) -->
    <div class="md:col-span-8 space-y-8 animate-fade-in-up delay-100">

      <!-- Countdown Timer -->
      <!-- Countdown Timer -->
      <div class="glass-card p-4 md:p-6 rounded-xl md:rounded-2xl">
        <div class="flex flex-col md:flex-row justify-between items-center gap-6">
          <div class="flex items-center gap-3">
            <div
              class="w-10 h-10 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-brand-secondary dark:text-brand-neon">
              <i class="far fa-clock text-xl"></i>
            </div>
            <div>
              <p class="text-gray-900 dark:text-white font-bold text-lg leading-none">Contagem Regressiva</p>
              <p class="text-gray-500 dark:text-gray-400 text-xs uppercase tracking-wider font-bold mt-1">Para o início
                do evento</p>
            </div>
          </div>

          <div id="countdown" class="flex flex-wrap justify-center gap-2 md:gap-3"
            data-date="<?php echo $event['start_date']; ?>">
            <div
              class="flex flex-col items-center justify-center bg-white dark:bg-black border border-gray-200 dark:border-gray-800 w-16 h-16 md:w-20 md:h-20 rounded-xl">
              <span class="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white font-mono leading-none"
                id="days">00</span>
              <span class="text-[9px] md:text-[10px] text-gray-500 uppercase font-bold mt-1">Dias</span>
            </div>
            <div
              class="flex flex-col items-center justify-center bg-white dark:bg-black border border-gray-200 dark:border-gray-800 w-16 h-16 md:w-20 md:h-20 rounded-xl">
              <span class="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white font-mono leading-none"
                id="hours">00</span>
              <span class="text-[9px] md:text-[10px] text-gray-500 uppercase font-bold mt-1">Horas</span>
            </div>
            <div
              class="flex flex-col items-center justify-center bg-white dark:bg-black border border-gray-200 dark:border-gray-800 w-16 h-16 md:w-20 md:h-20 rounded-xl">
              <span class="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white font-mono leading-none"
                id="minutes">00</span>
              <span class="text-[9px] md:text-[10px] text-gray-500 uppercase font-bold mt-1">Min</span>
            </div>
            <div
              class="flex flex-col items-center justify-center bg-white dark:bg-gray-900 border-2 border-brand-secondary dark:border-brand-neon w-16 h-16 md:w-20 md:h-20 rounded-xl shadow-lg shadow-brand-secondary/10 dark:shadow-brand-neon/10">
              <span
                class="text-2xl md:text-3xl font-bold text-brand-secondary dark:text-brand-neon font-mono leading-none"
                id="seconds">00</span>
              <span class="text-[9px] md:text-[10px] text-gray-500 uppercase font-bold mt-1">Seg</span>
            </div>
          </div>
        </div>
      </div>

      <!-- Mobile CTA Button (Below Countdown) -->
      <div class="md:hidden mt-4">
        <button onclick="document.querySelector('form[action=\'/checkout\']').scrollIntoView({behavior: 'smooth'})"
          class="w-full bg-brand-neon text-black font-black uppercase tracking-wider py-4 rounded-xl shadow-lg shadow-brand-neon/40 hover:shadow-brand-neon/60 transition transform hover:-translate-y-1 flex items-center justify-center gap-2">
          <span>Comprar Ingressos</span>
          <i class="fas fa-ticket-alt"></i>
        </button>
      </div>

      <!-- About -->
      <div class="space-y-6">
        <!-- Marketing Content -->
        <?php if (!empty($event['marketing_content'])): ?>
          <div class="prose dark:prose-invert prose-lg max-w-none text-gray-600 dark:text-gray-300">
            <?php echo $event['marketing_content']; ?>
          </div>
        <?php endif; ?>

        <div class="glass-card p-5 md:p-8 rounded-xl md:rounded-2xl">
          <h3 class="text-2xl font-bold mb-4 text-gray-900 dark:text-white flex items-center">
            <span class="w-1 h-8 bg-brand-secondary dark:bg-brand-neon rounded mr-4"></span>
            Sobre o Evento
          </h3>
          <p class="text-gray-600 dark:text-gray-300 leading-relaxed whitespace-pre-line text-lg">
            <?php echo htmlspecialchars($event['description']); ?>
          </p>
        </div>
      </div>


      <?php if (!empty($speakers)): ?>
        <div class="pt-8 border-t border-gray-200 dark:border-gray-800">
          <h3 class="text-2xl font-bold mb-8 text-gray-900 dark:text-white flex items-center gap-3">
            <span class="w-1 h-8 bg-brand-secondary dark:bg-brand-secondary rounded"></span>
            <span>
              Line-up / Convidados
            </span>
          </h3>
          <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
            <?php foreach ($speakers as $speaker): ?>
              <div
                class="glass-card p-6 rounded-2xl text-center group relative hover:-translate-y-2 transition duration-500 ease-out border border-gray-200 dark:border-white/5 hover:border-brand-neon/30 hover:shadow-brand-neon/10">
                <div
                  class="absolute inset-0 bg-gradient-to-b from-brand-neon/5 to-transparent opacity-0 group-hover:opacity-100 transition duration-500 rounded-2xl">
                </div>

                <div
                  class="relative w-28 h-28 mx-auto mb-4 rounded-full p-1 bg-gradient-to-tr from-gray-700 to-gray-900 group-hover:from-brand-neon group-hover:to-brand-secondary transition duration-500">
                  <div class="w-full h-full rounded-full overflow-hidden bg-gray-800 flex items-center justify-center">
                    <?php if (!empty($speaker['image_url'])): ?>
                      <img src="<?php echo htmlspecialchars($speaker['image_url']); ?>" alt=""
                        class="w-full h-full object-cover">
                    <?php else: ?>
                      <i class="fas fa-microphone-alt text-3xl text-gray-600 group-hover:text-white transition"></i>
                    <?php endif; ?>
                  </div>
                </div>

                <h4 class="font-bold text-gray-900 dark:text-white text-lg relative z-10">
                  <?php echo htmlspecialchars($speaker['name']); ?>
                </h4>
                <div
                  class="h-0.5 w-8 bg-brand-secondary dark:bg-brand-neon mx-auto my-3 opacity-30 group-hover:opacity-100 group-hover:w-16 transition-all duration-500">
                </div>
                <p
                  class="text-sm text-gray-500 dark:text-gray-400 font-medium uppercase tracking-wider relative z-10 group-hover:text-brand-secondary dark:group-hover:text-brand-neon transition">
                  <?php echo htmlspecialchars($speaker['topic']); ?>
                </p>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      <?php endif; ?>

      <!-- Mobile Sticky Buy Button -->
      <div
        class="fixed bottom-0 left-0 right-0 z-50 bg-white/95 dark:bg-black/90 backdrop-blur-xl border-t border-gray-200 dark:border-gray-800 p-4 md:hidden animate-fade-in-up">
        <div class="flex items-center justify-between gap-4">
          <div class="flex flex-col">
            <span class="text-gray-500 dark:text-gray-400 text-xs uppercase font-bold">A partir de</span>
            <?php
            $minPrice = 0;
            if (!empty($tickets)) {
              $prices = array_column($tickets, 'price');
              $minPrice = min($prices);
            }
            ?>
            <span class="text-gray-900 dark:text-white font-bold text-xl">R$
              <?php echo number_format($minPrice, 2, ',', '.'); ?></span>
          </div>
          <button onclick="document.querySelector('form[action=\'/checkout\']').scrollIntoView({behavior: 'smooth'})"
            class="flex-1 bg-brand-neon text-black font-bold uppercase tracking-wider py-3 rounded-xl shadow-lg shadow-brand-neon/30">
            Comprar <i class="fas fa-ticket-alt ml-2"></i>
          </button>
        </div>
      </div>

      <!-- Map & Location -->
      <div>
        <h3 class="text-2xl font-bold mb-6 text-gray-900 dark:text-white flex items-center">
          <span class="w-1 h-8 bg-gray-600 rounded mr-4"></span>
          Localização
        </h3>
        <div class="glass-card p-2 rounded-2xl overflow-hidden shadow-brand-neon/20">
          <?php
          $mapCode = $event['map_embed'];
          $hasMap = false;

          // Case 1: Full Iframe Code
          if (strpos($mapCode, '<iframe') !== false) {
            // Clean up width/height to fit container
            $mapCode = preg_replace('/width=".*?"/', 'width="100%"', $mapCode);
            $mapCode = preg_replace('/height=".*?"/', 'height="400"', $mapCode);
            // Apply styles via wrapper or inline if possible. 
            // It's hard to apply CSS filter to internal iframe content if from different domain, 
            // but we can apply filter to the iframe element itself.
            echo '<div class="map-container" style="filter: grayscale(100%) invert(92%) contrast(83%);">' . $mapCode . '</div>';
            $hasMap = true;
          }
          // Case 2: Just URL
          elseif (filter_var($mapCode, FILTER_VALIDATE_URL)) {
            echo '<iframe src="' . htmlspecialchars($mapCode) . '" width="100%" height="400" style="border:0; filter: grayscale(100%) invert(92%) contrast(83%);" allowfullscreen="" loading="lazy" class="rounded-xl"></iframe>';
            $hasMap = true;
          }
          // Case 3: Fallback to Location
          elseif (!empty($event['location'])) {
            $encodedLoc = urlencode($event['location']);
            echo '<iframe src="https://maps.google.com/maps?q=' . $encodedLoc . '&t=&z=13&ie=UTF8&iwloc=&output=embed" width="100%" height="400" style="border:0; filter: grayscale(100%) invert(92%) contrast(83%);" allowfullscreen="" loading="lazy" class="rounded-xl"></iframe>';
            $hasMap = true;
          }
          ?>

          <?php if (!$hasMap): ?>
            <div class="h-64 flex items-center justify-center bg-gray-800 rounded-xl text-gray-500">
              <div class="text-center">
                <i class="fas fa-map-marked-alt text-4xl mb-2 opacity-50"></i>
                <p>Mapa indisponível</p>
              </div>
            </div>
          <?php endif; ?>
          <div class="p-4 flex items-center justify-between">
            <div class="text-gray-600 dark:text-gray-300">
              <i class="fas fa-map-pin text-brand-secondary dark:text-brand-neon mr-2"></i>
              <?php echo htmlspecialchars($event['location']); ?>
            </div>
            <?php
            $mapLink = "https://maps.google.com/?q=" . urlencode($event['location']);
            $embedVal = $event['map_embed'];

            // 1. If iframe, extract src
            if (preg_match('/src="([^"]+)"/', $embedVal, $matches)) {
              $embedVal = $matches[1];
            }

            // 2. Validate extracted or raw URL
            if (filter_var($embedVal, FILTER_VALIDATE_URL)) {
              // Parse for 'q' parameter (best for accurate search)
              $query = parse_url($embedVal, PHP_URL_QUERY);
              parse_str($query ?? '', $params);

              if (!empty($params['q'])) {
                $mapLink = "https://maps.google.com/?q=" . urlencode($params['q']);
              }
              // If no 'q' but it's a direct share link (not embed), use it
              elseif (strpos($embedVal, 'embed') === false) {
                $mapLink = $embedVal;
              }
            }
            ?>
            <a href="<?php echo htmlspecialchars($mapLink); ?>" target="_blank"
              class="text-sm text-brand-neon hover:underline">Abrir no Maps &rarr;</a>
          </div>
        </div>
      </div>

    </div>

    <!-- Right Column: Tickets & Organizer (4 cols) -->
    <div class="md:col-span-4 space-y-8 relative">
      <div class="sticky top-24 space-y-6 animate-fade-in-up delay-200">

        <!-- Tickets Card -->
        <div
          class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-xl md:rounded-2xl p-4 md:p-6 shadow-2xl relative overflow-hidden transition-colors duration-300">
          <div class="absolute top-0 right-0 p-16 bg-brand-neon/5 rounded-full blur-3xl -mr-10 -mt-10"></div>

          <h3 class="text-xl font-bold mb-6 text-gray-900 dark:text-white relative z-10">Ingressos</h3>

          <form action="/checkout" method="GET" class="relative z-10 space-y-4">
            <?php if (empty($tickets)): ?>
              <div class="text-center py-8 text-gray-400 dark:text-gray-500">
                <i class="fas fa-ticket-alt text-3xl mb-2 opacity-50"></i>
                <p>Ingressos esgotados ou indisponíveis.</p>
              </div>
            <?php else: ?>
              <?php $ticketIndex = 0; ?>
              <?php foreach ($tickets as $ticket): ?>
                <?php
                $currentPrice = $ticket['price'];
                $isPromo = false;
                // Promo Logic reused
                if ($ticket['promotional_price'] && $ticket['is_active']) {
                  $now = new DateTime();
                  $promoStart = $ticket['promotion_start_date'] ? new DateTime($ticket['promotion_start_date']) : null;
                  $promoEnd = $ticket['promotion_end_date'] ? new DateTime($ticket['promotion_end_date']) : null;
                  if ((!$promoStart || $now >= $promoStart) && (!$promoEnd || $now <= $promoEnd)) {
                    $currentPrice = $ticket['promotional_price'];
                    $isPromo = true;
                  }
                }
                ?>
                <label class="block cursor-pointer group">
                  <input type="radio" name="ticket_id" value="<?php echo $ticket['id']; ?>" class="peer hidden" <?php echo $ticketIndex === 0 ? 'checked' : ''; ?>>
                  <div
                    class="bg-gray-50 dark:bg-black/40 border border-gray-300 dark:border-gray-700 p-4 rounded-xl peer-checked:border-brand-secondary dark:peer-checked:border-brand-neon peer-checked:bg-brand-secondary/10 dark:peer-checked:bg-brand-neon/10 transition-all duration-300 group-hover:border-brand-neon group-hover:shadow-brand-neon/40 relative">
                    <?php if ($isPromo): ?>
                      <span
                        class="absolute -top-2 -right-2 bg-green-500 text-black text-[10px] font-bold px-2 py-0.5 rounded shadow-lg transform rotate-3">OFERTA</span>
                    <?php endif; ?>

                    <div class="flex justify-between items-start mb-1">
                      <h4 class="font-bold text-gray-900 dark:text-white text-sm">
                        <?php echo htmlspecialchars($ticket['name']); ?>
                      </h4>
                      <span
                        class="text-[10px] text-gray-600 dark:text-gray-400 bg-gray-200 dark:bg-gray-800 px-1.5 py-0.5 rounded border border-gray-300 dark:border-gray-700"><?php echo htmlspecialchars($ticket['batch_name']); ?></span>
                    </div>

                    <div class="flex items-end gap-2">
                      <?php if ($ticket['price'] == 0): ?>
                        <span class="text-brand-secondary dark:text-brand-neon font-bold text-xl">GRÁTIS</span>
                      <?php elseif ($isPromo): ?>
                        <div class="flex flex-col">
                          <span class="text-gray-400 dark:text-gray-500 line-through text-xs">R$
                            <?php echo number_format($ticket['price'], 2, ',', '.'); ?></span>
                          <span class="text-green-600 dark:text-green-400 font-bold text-xl">R$
                            <?php echo number_format($currentPrice, 2, ',', '.'); ?></span>
                        </div>
                      <?php else: ?>
                        <span class="text-gray-900 dark:text-white font-bold text-xl">R$
                          <?php echo number_format($currentPrice, 2, ',', '.'); ?></span>
                      <?php endif; ?>
                    </div>
                  </div>
                </label>
                <?php $ticketIndex++; endforeach; ?>

              <button type="submit"
                class="w-full bg-brand-neon text-black font-black uppercase tracking-wider py-4 rounded-xl shadow-lg shadow-brand-neon/40 hover:shadow-brand-neon/60 transition transform hover:-translate-y-1 mt-4 flex items-center justify-center gap-2">
                <span>Garantir Ingressos</span>
                <i class="fas fa-arrow-right"></i>
              </button>
              <p class="text-center text-xs text-gray-500 mt-2 flex items-center justify-center gap-1">
                <i class="fas fa-lock"></i> Compra 100% Segura
              </p>
            <?php endif; ?>
          </form>
        </div>

        <!-- Organizer Widget -->
        <?php if (!empty($event['organizer_name'])): ?>
          <div class="glass-card p-4 md:p-6 rounded-xl md:rounded-2xl flex items-center justify-between">
            <div>
              <p class="text-xs text-gray-500 uppercase font-bold mb-1">Organizado por</p>
              <h4 class="font-bold text-gray-900 dark:text-white">
                <?php echo htmlspecialchars($event['organizer_name']); ?>
              </h4>
            </div>
            <div class="flex space-x-2">
              <?php if (!empty($event['social_instagram'])): ?>
                <a href="<?php echo htmlspecialchars($event['social_instagram']); ?>" target="_blank"
                  class="w-8 h-8 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-gray-400 hover:text-white hover:bg-gradient-to-tr hover:from-yellow-400 hover:via-red-500 hover:to-purple-500 transition">
                  <i class="fab fa-instagram"></i>
                </a>
              <?php endif; ?>
              <?php if (!empty($event['social_website'])): ?>
                <a href="<?php echo htmlspecialchars($event['social_website']); ?>" target="_blank"
                  class="w-8 h-8 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-gray-400 hover:text-white hover:bg-blue-500 transition">
                  <i class="fas fa-globe"></i>
                </a>
              <?php endif; ?>
              <?php if (!empty($event['social_whatsapp'])): ?>
                <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $event['social_whatsapp']); ?>"
                  target="_blank"
                  class="w-8 h-8 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-gray-400 hover:text-white hover:bg-green-500 transition">
                  <i class="fab fa-whatsapp"></i>
                </a>
              <?php endif; ?>
            </div>
          </div>
        <?php endif; ?>

        <!-- Share Widget -->
        <div class="glass-card p-4 md:p-6 rounded-xl md:rounded-2xl">
          <p class="text-xs text-gray-500 uppercase font-bold mb-3">Compartilhar Evento</p>
          <div class="flex gap-2">
            <?php
            $shareUrl = (defined('APP_URL') ? APP_URL : '') . '/event/' . $event['slug'];
            $shareText = urlencode('Confira este evento: ' . $event['title']);
            $shareUrlEnc = urlencode($shareUrl);
            ?>
            <!-- WhatsApp -->
            <a href="https://api.whatsapp.com/send?text=<?php echo $shareText . '%20' . $shareUrlEnc; ?>"
              target="_blank"
              class="flex-1 bg-green-600/20 hover:bg-green-600/40 text-green-500 hover:text-green-300 border border-green-600/30 rounded-xl py-3 flex items-center justify-center transition group">
              <i class="fab fa-whatsapp text-2xl group-hover:scale-110 transition"></i>
            </a>
            <!-- Telegram -->
            <a href="https://t.me/share/url?url=<?php echo $shareUrlEnc; ?>&text=<?php echo $shareText; ?>"
              target="_blank"
              class="flex-1 bg-blue-500/20 hover:bg-blue-500/40 text-blue-400 hover:text-blue-200 border border-blue-500/30 rounded-xl py-3 flex items-center justify-center transition group">
              <i class="fab fa-telegram-plane text-2xl group-hover:scale-110 transition"></i>
            </a>
            <!-- Facebook -->
            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $shareUrlEnc; ?>" target="_blank"
              class="flex-1 bg-blue-700/20 hover:bg-blue-700/40 text-blue-600 hover:text-blue-400 border border-blue-700/30 rounded-xl py-3 flex items-center justify-center transition group">
              <i class="fab fa-facebook text-2xl group-hover:scale-110 transition"></i>
            </a>
            <!-- Email -->
            <a href="mailto:?subject=<?php echo $shareText; ?>&body=<?php echo $shareUrlEnc; ?>"
              class="flex-1 bg-gray-700/20 hover:bg-gray-700/40 text-gray-400 hover:text-gray-200 border border-gray-700/30 rounded-xl py-3 flex items-center justify-center transition group">
              <i class="fas fa-envelope text-2xl group-hover:scale-110 transition"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="https://js.pusher.com/8.2/pusher.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', () => {
      // --- Pusher Realtime Setup ---
      Pusher.logToConsole = false; // Disable in prod

      const pusherKey = '<?php echo defined('PUSHER_KEY') ? PUSHER_KEY : ''; ?>';
      const pusherCluster = '<?php echo defined('PUSHER_CLUSTER') ? PUSHER_CLUSTER : ''; ?>';

      if (pusherKey) {
        const pusher = new Pusher(pusherKey, {
          cluster: pusherCluster
        });

        const channel = pusher.subscribe('ticket_updates');
        channel.bind('stock_change', function (data) {
          // data = { ticket_id, new_quantity, event_id }
          if (data.event_id && data.event_id != '<?php echo $event['id']; ?>') return;

          const ticketInput = document.querySelector(`input[name="ticket_id"][value="${data.ticket_id}"]`);
          if (ticketInput) {
            const container = ticketInput.nextElementSibling;

            if (data.new_quantity <= 0) {
              // Mark as Sold Out
              ticketInput.disabled = true;
              if (ticketInput.checked) ticketInput.checked = false;

              // Visual Disable
              container.classList.add('opacity-50', 'cursor-not-allowed');
              container.classList.remove('hover:border-brand-neon', 'hover:shadow-brand-neon/40');

              const priceEl = container.querySelector('.text-xl'); // The price span
              if (priceEl) {
                // Determine if inside a flex container or standalone
                const parent = priceEl.parentElement;
                parent.innerHTML = '<span class="text-red-500 font-bold text-xl">ESGOTADO</span>';
              }

              // Add badge if not exists
              const badge = document.createElement('span');
              badge.className = "absolute -top-2 -right-2 bg-red-600 text-white text-[10px] font-bold px-2 py-0.5 rounded shadow-lg";
              badge.innerText = "ESGOTADO";
              container.appendChild(badge);
            }
          }
        });
      }

      // --- Countdown & Logic ---
      const countdownEl = document.getElementById('countdown');
      const targetDate = new Date(countdownEl.dataset.date).getTime();

      const updateCountdown = () => {
        const now = new Date().getTime();
        const distance = targetDate - now;

        if (distance < 0) {
          document.getElementById('countdown').innerHTML = '<div class="text-brand-neon font-bold text-xl p-2 rounded tracking-widest animate-pulse">EVENTO INICIADO</div>';
          return;
        }

        const days = Math.floor(distance / (1000 * 60 * 60 * 24));
        const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((distance % (1000 * 60)) / 1000);

        document.getElementById('days').innerText = String(days).padStart(2, '0');
        document.getElementById('hours').innerText = String(hours).padStart(2, '0');
        document.getElementById('minutes').innerText = String(minutes).padStart(2, '0');
        document.getElementById('seconds').innerText = String(seconds).padStart(2, '0');
      };

      if (document.getElementById('countdown').dataset.date) {
        setInterval(updateCountdown, 1000);
        updateCountdown();
      }

      // Ticket Validation Logic
      const ticketForm = document.querySelector('form[action="/checkout"]');
      if (ticketForm) {
        ticketForm.addEventListener('submit', function (e) {
          const selectedTicket = document.querySelector('input[name="ticket_id"]:checked');
          if (!selectedTicket) {
            e.preventDefault();
            // Create a nice toast notification
            const toast = document.createElement('div');
            toast.className = 'fixed top-4 right-4 bg-red-600 text-white px-6 py-4 rounded-xl shadow-[0_0_20px_rgba(255,0,0,0.4)] z-50 flex items-center animate-fade-in-up';
            toast.innerHTML = '<i class="fas fa-exclamation-circle mr-3 text-xl"></i><span class="font-bold">Selecione um ingresso para continuar!</span>';
            document.body.appendChild(toast);

            // Shake the ticket container visual cue
            const ticketContainer = ticketForm.closest('.bg-gray-900');
            if (ticketContainer) {
              ticketContainer.classList.add('animate-pulse');
              ticketContainer.style.borderColor = 'red';
              setTimeout(() => {
                ticketContainer.classList.remove('animate-pulse');
                ticketContainer.style.borderColor = '#1f2937'; // gray-800
              }, 500);
            }

            setTimeout(() => {
              toast.remove();
            }, 3000);
          }
        });
      }
    });
  </script>

  <?php require_once APP_PATH . '/views/partials/footer.php'; ?>