<?php
$title = $title ?? 'Fale Conosco - Cê Vai';
require_once APP_PATH . '/views/partials/header.php';

// Fetch Settings if not available
$siteSettings = [];
if (file_exists(APP_PATH . '/models/Setting.php')) {
  require_once APP_PATH . '/models/Setting.php';
  if (class_exists('Setting')) {
    $settingModel = new Setting();
    $siteSettings = $settingModel->getAllAsArray();
  }
}

$contactEmail = $siteSettings['contact_email'] ?? 'contato@cevai.com';
$contactWhatsapp = $siteSettings['contact_whatsapp'] ?? '5511999999999';
$whatsappLink = preg_replace('/[^0-9]/', '', $contactWhatsapp);
?>

<div
  class="relative w-full min-h-screen pt-24 pb-20 bg-gray-50 dark:bg-brand-dark overflow-hidden transition-colors duration-300">

  <div class="container mx-auto px-6 relative z-10">

    <div class="text-center mb-16 animate-fade-in-up">
      <h1 class="text-4xl md:text-5xl font-black text-gray-900 dark:text-white mb-4">
        Fale <span class="text-brand-neon">Conosco</span>
      </h1>
      <p class="text-gray-600 dark:text-gray-400 max-w-2xl mx-auto text-lg">
        Tem alguma dúvida, sugestão ou precisa de ajuda com seus ingressos? Estamos aqui para ouvir você.
      </p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-start max-w-5xl mx-auto">

      <!-- Contact Form -->
      <div
        class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 p-8 rounded-xl shadow-xl animate-fade-in-up delay-100 transition-colors duration-300">
        <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-6 border-l-4 border-brand-neon pl-4">Envie uma
          mensagem</h3>

        <?php if (isset($_GET['msg']) && $_GET['msg'] == 'enviado'): ?>
          <div
            class="bg-green-100 dark:bg-green-900/20 border border-green-500 text-green-600 dark:text-green-400 p-4 rounded mb-6 text-center">
            <i class="fas fa-check-circle text-2xl mb-2 block"></i>
            <span class="font-bold block text-lg">Mensagem Enviada!</span>
            <span class="text-sm opacity-80">Recebemos seu contato e retornaremos em breve.</span>
          </div>
        <?php elseif (isset($_GET['error'])): ?>
          <div
            class="bg-red-100 dark:bg-red-900/20 border border-red-500 text-red-600 dark:text-red-500 p-4 rounded mb-6 text-center">
            <span class="font-bold">Ocorreu um erro ao enviar.</span>
            <span class="text-sm block">Por favor, tente novamente ou use o WhatsApp.</span>
          </div>
        <?php endif; ?>

        <form action="/contact/process" method="POST" class="space-y-4">
          <input type="hidden" name="csrf_token" value="<?php echo session_id(); ?>">

          <!-- Honeypot -->
          <div style="display:none; opacity:0; visibility:hidden;">
            <label>Não preencha este campo se for humano: <input type="text" name="website_check"
                autocomplete="off"></label>
          </div>

          <div>
            <label class="block text-gray-500 dark:text-gray-400 text-sm font-bold mb-2">Nome Completo</label>
            <input type="text" name="name" required placeholder="Seu nome"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-lg p-3 text-gray-900 dark:text-white focus:border-brand-neon focus:ring-1 focus:ring-brand-neon outline-none transition">
          </div>

          <div>
            <label class="block text-gray-500 dark:text-gray-400 text-sm font-bold mb-2">E-mail</label>
            <input type="email" name="email" required placeholder="seu@email.com"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-lg p-3 text-gray-900 dark:text-white focus:border-brand-neon focus:ring-1 focus:ring-brand-neon outline-none transition">
          </div>

          <div>
            <label class="block text-gray-500 dark:text-gray-400 text-sm font-bold mb-2">Assunto</label>
            <input type="text" name="subject" placeholder="Ex: Dúvida sobre ingresso"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-lg p-3 text-gray-900 dark:text-white focus:border-brand-neon focus:ring-1 focus:ring-brand-neon outline-none transition">
          </div>

          <div>
            <label class="block text-gray-500 dark:text-gray-400 text-sm font-bold mb-2">Mensagem</label>
            <textarea name="message" required rows="5" placeholder="Como podemos ajudar?"
              class="w-full bg-gray-50 dark:bg-black border border-gray-300 dark:border-gray-700 rounded-lg p-3 text-gray-900 dark:text-white focus:border-brand-neon focus:ring-1 focus:ring-brand-neon outline-none transition resize-none"></textarea>
          </div>

          <button type="submit"
            class="w-full bg-brand-neon hover:brightness-110 text-black font-black uppercase tracking-wider py-4 rounded-xl shadow-lg hover:shadow-brand-neon/20 transition transform hover:-translate-y-1 border border-transparent hover:border-brand-neon">
            Enviar Mensagem <i class="fas fa-paper-plane ml-2"></i>
          </button>
        </form>
      </div>

      <!-- Quick Contact Info -->
      <div class="space-y-6 animate-fade-in-up delay-200">

        <!-- WhatsApp Box -->
        <div
          class="bg-white dark:bg-gray-900 border border-l-4 border-gray-200 dark:border-gray-800 border-l-green-500 p-8 rounded-xl relative overflow-hidden group hover:border-green-500 transition duration-300 shadow-lg">

          <div class="relative z-10">
            <div class="flex items-center gap-4 mb-4">
              <div class="w-12 h-12 bg-green-500 rounded-lg flex items-center justify-center text-black text-2xl">
                <i class="fab fa-whatsapp"></i>
              </div>
              <h3 class="text-xl font-bold text-gray-900 dark:text-white">Atendimento via WhatsApp</h3>
            </div>

            <p class="text-gray-600 dark:text-gray-400 mb-6 text-sm">Resposta rápida para dúvidas urgentes.<br>Clique no
              botão abaixo para
              iniciar a conversa.</p>

            <a href="https://wa.me/<?php echo $whatsappLink; ?>" target="_blank"
              class="inline-flex items-center justify-center w-full py-3 bg-green-600 hover:bg-green-500 text-white font-bold rounded-lg transition gap-2 border border-transparent hover:border-green-400">
              <i class="fab fa-whatsapp"></i> Iniciar Conversa
            </a>
          </div>
        </div>

        <!-- Email Info -->
        <div
          class="bg-white dark:bg-gray-900 border border-l-4 border-gray-200 dark:border-gray-800 border-l-brand-neon p-6 rounded-xl hover:border-brand-neon transition duration-300 shadow-md">
          <div class="flex items-start gap-4">
            <div
              class="w-10 h-10 bg-gray-100 dark:bg-gray-800 rounded-lg flex items-center justify-center text-brand-neon text-lg shrink-0">
              <i class="fas fa-envelope"></i>
            </div>
            <div>
              <h4 class="font-bold text-gray-900 dark:text-white text-lg">E-mail</h4>
              <p class="text-gray-600 dark:text-gray-400 text-sm mb-1">Para parcerias e assuntos administrativos.</p>
              <a href="mailto:<?php echo htmlspecialchars($contactEmail); ?>"
                class="text-brand-neon hover:underline break-all"><?php echo htmlspecialchars($contactEmail); ?></a>
            </div>
          </div>
        </div>

        <!-- FAQ Link -->
        <div
          class="bg-gray-50 dark:bg-gray-900/50 border border-gray-200 dark:border-gray-800 p-8 rounded-2xl shadow-sm">
          <div class="flex items-start gap-4">
            <div
              class="w-12 h-12 bg-gray-100 dark:bg-gray-800 rounded-lg flex items-center justify-center text-brand-secondary text-xl shrink-0">
              <i class="fas fa-question-circle"></i>
            </div>
            <div>
              <h4 class="font-bold text-gray-900 dark:text-white text-lg">Dúvidas Frequentes</h4>
              <p class="text-gray-600 dark:text-gray-400 text-sm mb-1">Antes de enviar mensagem, veja se sua dúvida já
                foi respondida.</p>
              <a href="/terms" class="text-brand-secondary hover:underline">Ler Termos de Uso</a>
            </div>
          </div>
        </div>

      </div>

    </div>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>