<?php
$title = 'Política de Reembolso - ' . (APP_NAME ?? 'Cê Vai');
require_once APP_PATH . '/views/partials/header.php';
?>

<div class="max-w-4xl mx-auto px-4 py-12">
  <h1 class="text-3xl font-bold mb-8 text-brand-secondary dark:text-brand-neon">Política de Reembolso</h1>

  <div
    class="bg-white dark:bg-gray-900 p-8 rounded-lg shadow-sm border border-gray-200 dark:border-gray-800 prose dark:prose-invert max-w-none">

    <h3>1. Direito de Arrependimento (7 dias)</h3>
    <p>De acordo com o Artigo 49 do Código de Defesa do Consumidor (CDC), em compras realizadas fora do estabelecimento
      comercial (online), o consumidor tem até <strong>7 (sete) dias corridos</strong> após a compra para desistir da
      aquisição e solicitar o reembolso total, desde que a solicitação seja feita até 48 horas antes do início do
      evento.</p>

    <h3>2. Prazo para Solicitação</h3>
    <p>As solicitações de cancelamento e reembolso devem ser feitas dentro do prazo de 7 dias após a compra.
      Solicitações feitas após esse período não serão atendidas, exceto em casos de cancelamento do evento pela
      organização.</p>
    <p><strong>Atenção:</strong> Não realizamos reembolsos para solicitações feitas com menos de 48 horas de
      antecedência ao início do evento, mesmo que dentro do prazo de 7 dias da compra, devido à logística e reserva de
      vaga.</p>

    <h3>3. Como Solicitar</h3>
    <p>Para solicitar o reembolso, envie um e-mail para <strong>reembolso@cevai.com.br</strong> com as seguintes
      informações:</p>
    <ul class="list-disc pl-5 mt-2 mb-4">
      <li>Assunto do E-mail: Solicitação de Reembolso - [Seu Nome]</li>
      <li>Nome Completo utilizado na compra</li>
      <li>Número do Pedido ou Código do Ingresso</li>
      <li>Motivo do cancelamento (opcional, para melhoria de nossos serviços)</li>
    </ul>
    <p>É obrigatório anexar o comprovante de compra ou o ingresso à mensagem.</p>

    <h3>4. Prazos de Processamento</h3>
    <p>Após o recebimento do e-mail, nossa equipe analisará a solicitação em até 3 dias úteis. Se aprovado:</p>
    <ul>
      <li><strong>Cartão de Crédito/Débito:</strong> O estorno será solicitado à operadora do cartão e poderá aparecer
        na fatura atual ou na próxima (dependendo da data de fechamento).</li>
      <li><strong>Pix:</strong> O reembolso será feito na mesma conta de origem do pagamento em até 5 dias úteis após a
        aprovação.</li>
    </ul>

    <h3>5. Ingressos Já Utilizados</h3>
    <p>Não é possível solicitar reembolso de ingressos que já tenham realizado check-in (validação) no evento.</p>
  </div>
</div>

<?php require_once APP_PATH . '/views/partials/footer.php'; ?>