<?php
define('APP_PATH', __DIR__ . '/../app');
require_once APP_PATH . '/config/app_config.php';
require_once APP_PATH . '/config/database.php';

$database = new Database();
$db = $database->connect();

$output = "";

$output .= "=== EVENT SPEAKERS ===\n";
$stmt = $db->query("SELECT * FROM event_speakers");
$speakers = $stmt->fetchAll(PDO::FETCH_ASSOC);
if (count($speakers) > 0) {
  foreach ($speakers as $s) {
    $output .= "ID: {$s['id']} | EventID: {$s['event_id']} | Name: {$s['name']} | Topic: {$s['topic']}\n";
  }
} else {
  $output .= "No speakers found.\n";
}

$output .= "\n=== EVENTS ===\n";
$stmt = $db->query("SELECT id, title, slug FROM events");
$events = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($events as $e) {
  $output .= "ID: {$e['id']} | Title: {$e['title']} | Slug: {$e['slug']}\n";
}

file_put_contents(__DIR__ . '/../debug_state.log', $output);
echo "Debug state written to debug_state.log\n";
