<?php
define('APP_PATH', __DIR__ . '/../app');
require_once APP_PATH . '/config/app_config.php';
require_once APP_PATH . '/config/database.php';

$database = new Database();
$db = $database->connect();

// Get the first event ID
$stmt = $db->query("SELECT id FROM events LIMIT 1");
$event = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$event) {
  die("No events found to attach speaker to.\n");
}

$eventId = $event['id'];
echo "Inserting test speaker for Event ID: $eventId\n";

$sql = "INSERT INTO event_speakers (event_id, name, topic) VALUES (:event_id, 'Teste Manual', 'Injeção via Script')";
$stmt = $db->prepare($sql);
$stmt->bindValue(':event_id', $eventId);
if ($stmt->execute()) {
  echo "Speaker inserted successfully!\n";
} else {
  echo "Failed to insert speaker.\n";
}
