<?php

require_once __DIR__ . '/../app/config/app_config.php';
require_once __DIR__ . '/../app/config/database.php';

try {
  echo "Connecting to Database...\n";
  $db = new Database();
  $conn = $db->connect();

  // Add columns to ticket_types
  echo "Updating ticket_types table...\n";
  $sql = "ALTER TABLE ticket_types 
            ADD COLUMN promotional_price DECIMAL(10,2) DEFAULT NULL, 
            ADD COLUMN promotion_start_date DATETIME DEFAULT NULL, 
            ADD COLUMN promotion_end_date DATETIME DEFAULT NULL, 
            ADD COLUMN is_active BOOLEAN DEFAULT TRUE,
            ADD COLUMN batch_name VARCHAR(50) DEFAULT 'Lote 1'";

  try {
    $conn->exec($sql);
    echo "ticket_types updated successfully.\n";
  } catch (PDOException $e) {
    // Ignore if error is "Duplicate column name" (simple idempotency check)
    if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
      echo "ticket_types update skipped (columns likely exist).\n";
    } else {
      echo "Error updating ticket_types: " . $e->getMessage() . "\n";
    }
  }

  // Ensure Users have phone (check if needs modification or just alert)
  // It was in initial schema, so likely fine. 

  echo "Schema update completed.\n";

} catch (Exception $e) {
  die("Error: " . $e->getMessage() . "\n");
}
